/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.math.BigDecimal;
import java.util.Date;
import org.mozilla.javascript.Context;
import org.pentaho.di.compatibility.Value;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.xml.XMLHandler;

public class JavaScriptUtils {
    private static final String JS_UNDEFINED = "org.mozilla.javascript.Undefined";
    private static final String JS_NATIVE_JAVA_OBJ = "org.mozilla.javascript.NativeJavaObject";
    private static final String JS_NATIVE_NUM = "org.mozilla.javascript.NativeNumber";

    private JavaScriptUtils() {
    }

    public static Object convertFromJs(Object value, int type, String fieldName) throws KettleValueException {
        String classType = value.getClass().getName();
        switch (type) {
            case 1: {
                return JavaScriptUtils.jsToNumber(value, classType);
            }
            case 5: {
                return JavaScriptUtils.jsToInteger(value, value.getClass());
            }
            case 2: {
                return JavaScriptUtils.jsToString(value, classType);
            }
            case 3: {
                return JavaScriptUtils.jsToDate(value, classType);
            }
            case 4: {
                return value;
            }
            case 6: {
                return JavaScriptUtils.jsToBigNumber(value, classType);
            }
            case 8: {
                return Context.jsToJava((Object)value, byte[].class);
            }
            case 0: {
                throw new KettleValueException("No data output data type was specified for new field [" + fieldName + "]");
            }
        }
        return Context.jsToJava((Object)value, Object.class);
    }

    public static Number jsToNumber(Object value, String classType) {
        if (classType.equalsIgnoreCase(JS_UNDEFINED)) {
            return null;
        }
        if (classType.equalsIgnoreCase(JS_NATIVE_JAVA_OBJ)) {
            try {
                Value v = (Value)Context.jsToJava((Object)value, Value.class);
                return v.getNumber();
            }
            catch (Exception e) {
                String string = Context.toString((Object)value);
                return Double.parseDouble(Const.trim((String)string));
            }
        }
        if (classType.equalsIgnoreCase(JS_NATIVE_NUM)) {
            Double nb = Context.toNumber((Object)value);
            return (double)nb;
        }
        Number nb = (Number)value;
        return nb.doubleValue();
    }

    public static Long jsToInteger(Object value, Class<?> clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            return ((Number)value).longValue();
        }
        String classType = clazz.getName();
        if (classType.equalsIgnoreCase("java.lang.String")) {
            return new Long((String)value);
        }
        if (classType.equalsIgnoreCase(JS_UNDEFINED)) {
            return null;
        }
        if (classType.equalsIgnoreCase(JS_NATIVE_NUM)) {
            Double nb = Context.toNumber((Object)value);
            return ((Number)nb).longValue();
        }
        if (classType.equalsIgnoreCase(JS_NATIVE_JAVA_OBJ)) {
            try {
                Value v = (Value)Context.jsToJava((Object)value, Value.class);
                return v.getInteger();
            }
            catch (Exception e2) {
                String string = Context.toString((Object)value);
                return Long.parseLong(Const.trim((String)string));
            }
        }
        return Long.parseLong(value.toString());
    }

    public static String jsToString(Object value, String classType) {
        if (classType.equalsIgnoreCase(JS_NATIVE_JAVA_OBJ) || classType.equalsIgnoreCase(JS_UNDEFINED)) {
            try {
                Value v = (Value)Context.jsToJava((Object)value, Value.class);
                return v.toString();
            }
            catch (Exception ev) {
                return Context.toString((Object)value);
            }
        }
        return Context.toString((Object)value);
    }

    public static Date jsToDate(Object value, String classType) throws KettleValueException {
        if (!classType.equalsIgnoreCase(JS_UNDEFINED)) {
            double dbl;
            if (classType.equalsIgnoreCase("org.mozilla.javascript.NativeDate")) {
                dbl = Context.toNumber((Object)value);
            } else if (classType.equalsIgnoreCase(JS_NATIVE_JAVA_OBJ) || classType.equalsIgnoreCase("java.util.Date")) {
                try {
                    Date dat = (Date)Context.jsToJava((Object)value, Date.class);
                    dbl = dat.getTime();
                }
                catch (Exception e) {
                    return JavaScriptUtils.convertValueToDate(value);
                }
            } else if (classType.equalsIgnoreCase("java.lang.Double")) {
                dbl = (Double)value;
            } else {
                String string = (String)Context.jsToJava((Object)value, String.class);
                dbl = Double.parseDouble(string);
            }
            long lng = Math.round(dbl);
            return new Date(lng);
        }
        return null;
    }

    public static BigDecimal jsToBigNumber(Object value, String classType) {
        if (classType.equalsIgnoreCase(JS_UNDEFINED)) {
            return null;
        }
        if (classType.equalsIgnoreCase(JS_NATIVE_NUM)) {
            Double nb = Context.toNumber((Object)value);
            return BigDecimal.valueOf(nb);
        }
        if (classType.equalsIgnoreCase(JS_NATIVE_JAVA_OBJ)) {
            return JavaScriptUtils.convertNativeJavaToBigDecimal(value);
        }
        if (classType.equalsIgnoreCase("java.lang.Byte")) {
            return BigDecimal.valueOf(((Byte)value).longValue());
        }
        if (classType.equalsIgnoreCase("java.lang.Short")) {
            return BigDecimal.valueOf(((Short)value).longValue());
        }
        if (classType.equalsIgnoreCase("java.lang.Integer")) {
            return BigDecimal.valueOf(((Integer)value).longValue());
        }
        if (classType.equalsIgnoreCase("java.lang.Long")) {
            return BigDecimal.valueOf((Long)value);
        }
        if (classType.equalsIgnoreCase("java.lang.Double")) {
            return BigDecimal.valueOf((Double)value);
        }
        if (classType.equalsIgnoreCase("java.lang.String")) {
            return BigDecimal.valueOf(new Long((String)value));
        }
        throw new UnsupportedOperationException("JavaScript conversion to BigNumber not implemented for " + classType);
    }

    private static BigDecimal convertNativeJavaToBigDecimal(Object value) {
        try {
            return (BigDecimal)Context.jsToJava((Object)value, BigDecimal.class);
        }
        catch (Exception e) {
            try {
                Value v = (Value)Context.jsToJava((Object)value, Value.class);
                if (!v.isNull()) {
                    return v.getBigNumber();
                }
                return null;
            }
            catch (Exception e2) {
                String string = (String)Context.jsToJava((Object)value, String.class);
                return new BigDecimal(string);
            }
        }
    }

    private static Date convertValueToDate(Object value) throws KettleValueException {
        try {
            Value v = (Value)Context.jsToJava((Object)value, Value.class);
            return v.getDate();
        }
        catch (Exception e2) {
            try {
                String string = Context.toString((Object)value);
                return XMLHandler.stringToDate((String)string);
            }
            catch (Exception e3) {
                throw new KettleValueException("Can't convert a string to a date");
            }
        }
    }
}

