/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.listeners.impl;

import com.google.common.base.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.listeners.CurrentDirectoryChangedListener;
import org.pentaho.di.core.variables.Variables;

public class EntryCurrentDirectoryChangedListener
implements CurrentDirectoryChangedListener {
    private PathReference[] references;

    public EntryCurrentDirectoryChangedListener(PathReference ... refs) {
        this.references = refs;
    }

    public EntryCurrentDirectoryChangedListener(final Supplier<ObjectLocationSpecificationMethod> specMethodGetter, final Supplier<String> pathGetter, final Consumer<String> pathSetter) {
        this(new PathReference(){

            @Override
            public ObjectLocationSpecificationMethod getSpecification() {
                return (ObjectLocationSpecificationMethod)specMethodGetter.get();
            }

            @Override
            public String getPath() {
                return (String)pathGetter.get();
            }

            @Override
            public void setPath(String path) {
                pathSetter.accept(path);
            }
        });
    }

    @Override
    public void directoryChanged(Object origin, String oldCurrentDir, String newCurrentDir) {
        for (PathReference ref : this.references) {
            ObjectLocationSpecificationMethod specMethod = ref.getSpecification();
            String path = ref.getPath();
            if (specMethod != ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME && specMethod != ObjectLocationSpecificationMethod.FILENAME || !StringUtils.contains((String)path, (String)"Internal.Entry.Current.Directory") || Objects.equal((Object)oldCurrentDir, (Object)newCurrentDir)) continue;
            path = this.reapplyCurrentDir(oldCurrentDir, newCurrentDir, path);
            ref.setPath(path);
        }
    }

    private String reapplyCurrentDir(String oldCurrentDir, String newCurrentDir, String path) {
        Variables vars = new Variables();
        vars.setVariable("Internal.Entry.Current.Directory", oldCurrentDir);
        String newPath = vars.environmentSubstitute(path);
        return EntryCurrentDirectoryChangedListener.getPath(newCurrentDir, newPath);
    }

    private static String getPath(String parentPath, String path) {
        if (!parentPath.equals("/") && path.startsWith(parentPath)) {
            path = path.replace(parentPath, "${Internal.Entry.Current.Directory}");
        }
        return path;
    }

    public static interface PathReference {
        public ObjectLocationSpecificationMethod getSpecification();

        public String getPath();

        public void setPath(String var1);
    }
}

