/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WebResult {
    private static Class<?> PKG = WebResult.class;
    public static final String XML_TAG = "webresult";
    public static final String STRING_OK = "OK";
    public static final String STRING_ERROR = "ERROR";
    public static final WebResult OK = new WebResult("OK");
    private String result;
    private String message;
    private String id;

    public WebResult(String result) {
        this(result, null, null);
    }

    public WebResult(String result, String message) {
        this(result, message, null);
    }

    public WebResult(String result, String message, String id) {
        this.result = result;
        this.message = message;
        this.id = id;
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("<webresult>").append(Const.CR);
        xml.append("  ").append(XMLHandler.addTagValue("result", this.result));
        xml.append("  ").append(XMLHandler.addTagValue("message", this.message));
        xml.append("  ").append(XMLHandler.addTagValue("id", this.id));
        xml.append("</webresult>").append(Const.CR);
        return xml.toString();
    }

    public String toString() {
        return this.getXML();
    }

    public WebResult(Node webResultNode) {
        this.result = XMLHandler.getTagValue(webResultNode, "result");
        this.message = XMLHandler.getTagValue(webResultNode, "message");
        this.id = XMLHandler.getTagValue(webResultNode, "id");
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static WebResult fromXMLString(String xml) throws KettleXMLException {
        try {
            Document doc = XMLHandler.loadXMLString(xml);
            Node node = XMLHandler.getSubNode(doc, XML_TAG);
            return new WebResult(node);
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, "WebResult.Error.UnableCreateResult", new String[0]), e);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

