/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.i18n;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.EnvUtil;

public class LanguageChoice {
    private static final String STRING_DEFAULT_LOCALE = "LocaleDefault";
    private static LanguageChoice choice;
    private Locale defaultLocale;

    private LanguageChoice() {
        block2: {
            try {
                this.loadSettings();
            }
            catch (IOException e) {
                this.defaultLocale = Const.DEFAULT_LOCALE;
                if (!this.defaultLocale.getLanguage().equals(Locale.GERMAN.getLanguage())) break block2;
                this.defaultLocale = Locale.US;
            }
        }
    }

    public static final LanguageChoice getInstance() {
        if (choice != null) {
            return choice;
        }
        choice = new LanguageChoice();
        return choice;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() throws IOException {
        Properties properties = new Properties();
        FileInputStream fis = new FileInputStream(this.getSettingsFilename());
        try {
            properties.load(fis);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        String defaultLocaleStr = properties.getProperty(STRING_DEFAULT_LOCALE, Const.DEFAULT_LOCALE.toString());
        this.defaultLocale = EnvUtil.createLocale(defaultLocaleStr);
    }

    public void saveSettings() {
        try {
            Properties properties = new Properties();
            properties.setProperty(STRING_DEFAULT_LOCALE, this.defaultLocale.toString());
            properties.store(new FileOutputStream(this.getSettingsFilename()), "Language Choice");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getSettingsFilename() {
        return Const.getKettleDirectory() + Const.FILE_SEPARATOR + ".languageChoice";
    }
}

