/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.util.List;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.variables.VariableSpace;

public class Utils {
    private static final int[] ZERO_LENGTH_INT_ARRAY = new int[0];

    private static int damerauLevenshteinDistance(String s, String t, int[] workspace) {
        int lenS = s.length();
        int lenT = t.length();
        int lenS1 = lenS + 1;
        int lenT1 = lenT + 1;
        if (lenT1 == 1) {
            return lenS1 - 1;
        }
        if (lenS1 == 1) {
            return lenT1 - 1;
        }
        int[] dl = workspace;
        int dlIndex = 0;
        int sPrevIndex = 0;
        int tPrevIndex = 0;
        int rowBefore = 0;
        int min = 0;
        int cost = 0;
        int tmp = 0;
        int tri = lenS1 + 2;
        dlIndex = 0;
        tmp = 0;
        while (tmp < lenT1) {
            dl[dlIndex] = tmp++;
            dlIndex += lenS1;
        }
        int sIndex = 0;
        while (sIndex < lenS) {
            dl[dlIndex] = dlIndex = sIndex + 1;
            int tIndex = 0;
            while (tIndex < lenT) {
                tmp = dl[(dlIndex += lenS1) - 1] + 1;
                if (tmp < (min = dl[rowBefore = dlIndex] + 1)) {
                    min = tmp;
                }
                cost = 1;
                if (s.charAt(sIndex) == t.charAt(tIndex)) {
                    cost = 0;
                }
                if (sIndex > 0 && tIndex > 0 && s.charAt(sIndex) == t.charAt(tPrevIndex) && s.charAt(sPrevIndex) == t.charAt(tIndex) && (tmp = dl[rowBefore - tri] + cost) < min) {
                    min = tmp;
                }
                if ((tmp = dl[rowBefore - 1] + cost) < min) {
                    min = tmp;
                }
                dl[dlIndex] = min;
                tPrevIndex = tIndex++;
            }
            sPrevIndex = sIndex++;
        }
        return dl[dlIndex];
    }

    private static int[] getWorkspace(int sl, int tl) {
        return new int[(sl + 1) * (tl + 1)];
    }

    public static int getDamerauLevenshteinDistance(String s, String t) {
        if (s != null && t != null) {
            return Utils.damerauLevenshteinDistance(s, t, Utils.getWorkspace(s.length(), t.length()));
        }
        return Utils.damerauLevenshteinDistance(s, t, ZERO_LENGTH_INT_ARRAY);
    }

    public static boolean isEmpty(CharSequence val) {
        return val == null || val.length() == 0;
    }

    public static boolean isEmpty(CharSequence[] strings) {
        return strings == null || strings.length == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    public static String resolvePassword(VariableSpace variables, String password) {
        String resolvedPassword = variables.environmentSubstitute(password);
        if (resolvedPassword != null) {
            return Encr.decryptPasswordOptionallyEncrypted(resolvedPassword);
        }
        return resolvedPassword;
    }

    public static String[][] normalizeArrays(int normalizeToLength, String[] ... arraysToNormalize) {
        if (arraysToNormalize == null) {
            return null;
        }
        int arraysToProcess = arraysToNormalize.length;
        String[][] rtn = new String[arraysToProcess][];
        for (int i = 0; i < arraysToNormalize.length; ++i) {
            String[] nextArray = arraysToNormalize[i];
            if (nextArray != null) {
                if (nextArray.length < normalizeToLength) {
                    String[] newArray = new String[normalizeToLength];
                    System.arraycopy(nextArray, 0, newArray, 0, nextArray.length);
                    rtn[i] = newArray;
                    continue;
                }
                rtn[i] = nextArray;
                continue;
            }
            rtn[i] = new String[normalizeToLength];
        }
        return rtn;
    }

    public static long[][] normalizeArrays(int normalizeToLength, long[] ... arraysToNormalize) {
        if (arraysToNormalize == null) {
            return null;
        }
        int arraysToProcess = arraysToNormalize.length;
        long[][] rtn = new long[arraysToProcess][];
        for (int i = 0; i < arraysToNormalize.length; ++i) {
            long[] nextArray = arraysToNormalize[i];
            if (nextArray != null) {
                if (nextArray.length < normalizeToLength) {
                    long[] newArray = new long[normalizeToLength];
                    System.arraycopy(nextArray, 0, newArray, 0, nextArray.length);
                    rtn[i] = newArray;
                    continue;
                }
                rtn[i] = nextArray;
                continue;
            }
            rtn[i] = new long[normalizeToLength];
        }
        return rtn;
    }

    public static int[][] normalizeArrays(int normalizeToLength, int[] ... arraysToNormalize) {
        if (arraysToNormalize == null) {
            return null;
        }
        int arraysToProcess = arraysToNormalize.length;
        int[][] rtn = new int[arraysToProcess][];
        for (int i = 0; i < arraysToNormalize.length; ++i) {
            int[] nextArray = arraysToNormalize[i];
            if (nextArray != null) {
                if (nextArray.length < normalizeToLength) {
                    int[] newArray = new int[normalizeToLength];
                    System.arraycopy(nextArray, 0, newArray, 0, nextArray.length);
                    rtn[i] = newArray;
                    continue;
                }
                rtn[i] = nextArray;
                continue;
            }
            rtn[i] = new int[normalizeToLength];
        }
        return rtn;
    }

    public static boolean[][] normalizeArrays(int normalizeToLength, boolean[] ... arraysToNormalize) {
        if (arraysToNormalize == null) {
            return null;
        }
        int arraysToProcess = arraysToNormalize.length;
        boolean[][] rtn = new boolean[arraysToProcess][];
        for (int i = 0; i < arraysToNormalize.length; ++i) {
            boolean[] nextArray = arraysToNormalize[i];
            if (nextArray != null) {
                if (nextArray.length < normalizeToLength) {
                    boolean[] newArray = new boolean[normalizeToLength];
                    System.arraycopy(nextArray, 0, newArray, 0, nextArray.length);
                    rtn[i] = newArray;
                    continue;
                }
                rtn[i] = nextArray;
                continue;
            }
            rtn[i] = new boolean[normalizeToLength];
        }
        return rtn;
    }

    public static short[][] normalizeArrays(int normalizeToLength, short[] ... arraysToNormalize) {
        if (arraysToNormalize == null) {
            return null;
        }
        int arraysToProcess = arraysToNormalize.length;
        short[][] rtn = new short[arraysToProcess][];
        for (int i = 0; i < arraysToNormalize.length; ++i) {
            short[] nextArray = arraysToNormalize[i];
            if (nextArray != null) {
                if (nextArray.length < normalizeToLength) {
                    short[] newArray = new short[normalizeToLength];
                    System.arraycopy(nextArray, 0, newArray, 0, nextArray.length);
                    rtn[i] = newArray;
                    continue;
                }
                rtn[i] = nextArray;
                continue;
            }
            rtn[i] = new short[normalizeToLength];
        }
        return rtn;
    }
}

