/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

public class RowDataUtil {
    public static int OVER_ALLOCATE_SIZE = 10;

    public static Object[] allocateRowData(int size) {
        return new Object[size + OVER_ALLOCATE_SIZE];
    }

    public static Object[] resizeArray(Object[] objects, int newSize) {
        if (objects != null && objects.length >= newSize) {
            return objects;
        }
        Object[] newObjects = new Object[newSize + OVER_ALLOCATE_SIZE];
        if (objects != null) {
            System.arraycopy(objects, 0, newObjects, 0, objects.length);
        }
        return newObjects;
    }

    public static Object[] createResizedCopy(Object[] objects, int newSize) {
        Object[] newObjects = objects.length < newSize ? new Object[newSize + OVER_ALLOCATE_SIZE] : new Object[objects.length];
        if (objects != null) {
            System.arraycopy(objects, 0, newObjects, 0, objects.length);
        }
        return newObjects;
    }

    public static Object[] createResizedCopy(Object[][] objects, int[] lengths) {
        int size = 0;
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                size += lengths[i];
            }
        }
        Object[] newObjects = RowDataUtil.allocateRowData(size);
        if (objects != null) {
            size = 0;
            for (int i = 0; i < lengths.length; ++i) {
                System.arraycopy(objects[i], 0, newObjects, size, lengths[i]);
                size += lengths[i];
            }
        }
        return newObjects;
    }

    public static Object[] removeItem(Object[] objects, int index) {
        Object[] newObjects = new Object[objects.length - 1];
        System.arraycopy(objects, 0, newObjects, 0, index);
        System.arraycopy(objects, index + 1, newObjects, index, objects.length - index - 1);
        return newObjects;
    }

    public static Object[] addRowData(Object[] one, int sourceLength, Object[] two) {
        Object[] result = RowDataUtil.resizeArray(one, sourceLength + two.length);
        System.arraycopy(two, 0, result, sourceLength, two.length);
        return result;
    }

    public static Object[] addValueData(Object[] rowData, int length, Object extra) {
        Object[] result = RowDataUtil.resizeArray(rowData, length + 1);
        result[length] = extra;
        return result;
    }

    public static Object[] removeItems(Object[] rowData, int[] index) {
        Object[] data = new Object[rowData.length - index.length];
        int count = data.length - 1;
        int removenr = index.length - 1;
        for (int i = rowData.length - 1; i >= 0; --i) {
            if (removenr >= 0 && i == index[removenr]) {
                --removenr;
                continue;
            }
            data[count] = rowData[i];
            --count;
        }
        return data;
    }
}

