/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettlePluginClassMapException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.Metrics;
import org.pentaho.di.core.logging.MetricsInterface;
import org.pentaho.di.core.plugins.ClassLoadingPluginInterface;
import org.pentaho.di.core.plugins.JarFileCache;
import org.pentaho.di.core.plugins.KettleSelectiveParentFirstClassLoader;
import org.pentaho.di.core.plugins.KettleURLClassLoader;
import org.pentaho.di.core.plugins.Plugin;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistryExtension;
import org.pentaho.di.core.plugins.PluginRegistryPluginType;
import org.pentaho.di.core.plugins.PluginTypeCategoriesOrder;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.PluginTypeListener;
import org.pentaho.di.core.plugins.SupplementalPlugin;
import org.pentaho.di.core.row.RowBuffer;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;

public class PluginRegistry {
    private static final Class<?> PKG = PluginRegistry.class;
    private static final PluginRegistry pluginRegistry = new PluginRegistry();
    private static final Set<PluginTypeInterface> pluginTypes = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Set<PluginRegistryExtension> extensions = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ReentrantReadWriteLock staticLock = new ReentrantReadWriteLock();
    private static final String SUPPLEMENTALS_SUFFIX = "-supplementals";
    public static final LogChannelInterface log = new LogChannel((Object)"PluginRegistry", true);
    private final Map<Class<? extends PluginTypeInterface>, Set<PluginInterface>> pluginMap = new HashMap<Class<? extends PluginTypeInterface>, Set<PluginInterface>>();
    private final Map<Class<? extends PluginTypeInterface>, Map<PluginInterface, URLClassLoader>> classLoaderMap = new HashMap<Class<? extends PluginTypeInterface>, Map<PluginInterface, URLClassLoader>>();
    private final Map<URLClassLoader, Set<PluginInterface>> inverseClassLoaderLookup = new HashMap<URLClassLoader, Set<PluginInterface>>();
    private final Map<String, URLClassLoader> classLoaderGroupsMap = new HashMap<String, URLClassLoader>();
    private final Map<String, URLClassLoader> folderBasedClassLoaderMap = new HashMap<String, URLClassLoader>();
    private final Map<Class<? extends PluginTypeInterface>, Set<String>> categoryMap = new HashMap<Class<? extends PluginTypeInterface>, Set<String>>();
    private final Map<PluginInterface, String[]> parentClassloaderPatternMap = new HashMap<PluginInterface, String[]>();
    private final Map<Class<? extends PluginTypeInterface>, Set<PluginTypeListener>> listeners = new HashMap<Class<? extends PluginTypeInterface>, Set<PluginTypeListener>>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final int WAIT_FOR_PLUGIN_TO_BE_AVAILABLE_LIMIT = 3000;

    private PluginRegistry() {
    }

    public static PluginRegistry getInstance() {
        return pluginRegistry;
    }

    private static Comparator<String> getNaturalCategoriesOrderComparator(Class<? extends PluginTypeInterface> pluginType) {
        String[] naturalOrder;
        PluginTypeCategoriesOrder naturalOrderAnnotation = pluginType.getAnnotation(PluginTypeCategoriesOrder.class);
        if (naturalOrderAnnotation != null) {
            String[] naturalOrderKeys = naturalOrderAnnotation.getNaturalCategoriesOrder();
            Class<?> i18nClass = naturalOrderAnnotation.i18nPackageClass();
            naturalOrder = (String[])Arrays.stream(naturalOrderKeys).map(key -> BaseMessages.getString(i18nClass, key, new String[0])).toArray(String[]::new);
        } else {
            naturalOrder = null;
        }
        return (s1, s2) -> {
            if (naturalOrder != null) {
                int idx1 = Const.indexOfString(s1, naturalOrder);
                int idx2 = Const.indexOfString(s2, naturalOrder);
                if (idx1 > -1 && idx2 > -1) {
                    return idx1 - idx2;
                }
                if (idx1 > -1) {
                    return -1;
                }
                if (idx2 > -1) {
                    return 1;
                }
            }
            return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
        };
    }

    public void registerPluginType(Class<? extends PluginTypeInterface> pluginType) {
        this.lock.writeLock().lock();
        try {
            this.pluginMap.computeIfAbsent(pluginType, k -> new TreeSet<PluginInterface>(Plugin.nullStringComparator));
            this.categoryMap.computeIfAbsent(pluginType, k -> new TreeSet<String>(PluginRegistry.getNaturalCategoriesOrderComparator(pluginType)));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlugin(Class<? extends PluginTypeInterface> pluginType, PluginInterface plugin) {
        this.lock.writeLock().lock();
        try {
            URLClassLoader ucl;
            Map<PluginInterface, URLClassLoader> classLoaders;
            Set<PluginInterface> list = this.pluginMap.get(pluginType);
            if (list != null) {
                list.remove(plugin);
            }
            if ((classLoaders = this.classLoaderMap.get(plugin.getPluginType())) != null) {
                classLoaders.remove(plugin);
            }
            if (!Utils.isEmpty(plugin.getClassLoaderGroup()) && (ucl = this.classLoaderGroupsMap.remove(plugin.getClassLoaderGroup())) != null && classLoaders != null) {
                for (PluginInterface p : this.inverseClassLoaderLookup.remove(ucl)) {
                    classLoaders.remove(p);
                }
                try {
                    ucl.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (plugin.getPluginDirectory() != null) {
                this.folderBasedClassLoaderMap.remove(plugin.getPluginDirectory().toString());
            }
        }
        finally {
            this.lock.writeLock().unlock();
            Set<PluginTypeListener> listeners = this.listeners.get(pluginType);
            if (listeners != null) {
                for (PluginTypeListener listener : listeners) {
                    listener.pluginRemoved(plugin);
                }
            }
            PluginRegistry pluginRegistry = this;
            synchronized (pluginRegistry) {
                this.notifyAll();
            }
        }
    }

    public void addParentClassLoaderPatterns(PluginInterface plugin, String[] patterns) {
        this.lock.writeLock().lock();
        try {
            this.parentClassloaderPatternMap.put(plugin, patterns);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlugin(Class<? extends PluginTypeInterface> pluginType, PluginInterface plugin) throws KettlePluginException {
        boolean changed = false;
        this.lock.writeLock().lock();
        try {
            if (plugin.getIds()[0] == null) {
                throw new KettlePluginException("Not a valid id specified in plugin :" + plugin);
            }
            Set list = this.pluginMap.computeIfAbsent(pluginType, k -> new TreeSet<PluginInterface>(Plugin.nullStringComparator));
            if (!list.add(plugin)) {
                list.remove(plugin);
                list.add(plugin);
                changed = true;
            }
            if (!Utils.isEmpty(plugin.getCategory())) {
                this.categoryMap.computeIfAbsent(pluginType, k -> new TreeSet<String>(PluginRegistry.getNaturalCategoriesOrderComparator(pluginType))).add(plugin.getCategory());
            }
        }
        finally {
            this.lock.writeLock().unlock();
            Set<PluginTypeListener> listeners = this.listeners.get(pluginType);
            if (listeners != null) {
                for (PluginTypeListener listener : listeners) {
                    if (changed) {
                        listener.pluginChanged(plugin);
                        continue;
                    }
                    listener.pluginAdded(plugin);
                }
            }
            PluginRegistry pluginRegistry = this;
            synchronized (pluginRegistry) {
                this.notifyAll();
            }
        }
    }

    public List<Class<? extends PluginTypeInterface>> getPluginTypes() {
        this.lock.readLock().lock();
        try {
            List<Class<? extends PluginTypeInterface>> list = Collections.unmodifiableList(new ArrayList<Class<? extends PluginTypeInterface>>(this.pluginMap.keySet()));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T extends PluginInterface, K extends PluginTypeInterface> List<T> getPlugins(Class<K> type) {
        List result;
        this.lock.readLock().lock();
        try {
            result = this.pluginMap.keySet().stream().filter(pi -> Const.classIsOrExtends(pi, type)).flatMap(pi -> this.pluginMap.get(pi).stream()).map(p -> p).collect(Collectors.toList());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public PluginInterface getPlugin(Class<? extends PluginTypeInterface> pluginType, String id) {
        if (Utils.isEmpty(id)) {
            return null;
        }
        return this.getPlugins(pluginType).stream().filter(plugin -> plugin.matches(id)).findFirst().orElse(null);
    }

    public <T extends PluginTypeInterface> List<PluginInterface> getPluginsByCategory(Class<T> pluginType, String pluginCategory) {
        List plugins = this.getPlugins(pluginType).stream().filter(plugin -> plugin.getCategory() != null && plugin.getCategory().equals(pluginCategory)).collect(Collectors.toList());
        return Collections.unmodifiableList(plugins);
    }

    public List<String> getCategories(Class<? extends PluginTypeInterface> pluginType) {
        this.lock.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>((Collection)this.categoryMap.get(pluginType));
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Object loadClass(PluginInterface plugin) throws KettlePluginException {
        return this.loadClass(plugin, plugin.getMainType());
    }

    public <T> T loadClass(Class<? extends PluginTypeInterface> pluginType, Object object, Class<T> classType) throws KettlePluginException {
        PluginInterface plugin = this.getPlugin(pluginType, object);
        if (plugin == null) {
            return null;
        }
        return this.loadClass(plugin, classType);
    }

    public <T> T loadClass(Class<? extends PluginTypeInterface> pluginType, String pluginId, Class<T> classType) throws KettlePluginException {
        PluginInterface plugin = this.getPlugin(pluginType, pluginId);
        if (plugin == null) {
            return null;
        }
        return this.loadClass(plugin, classType);
    }

    private KettleURLClassLoader createClassLoader(PluginInterface plugin) throws MalformedURLException, UnsupportedEncodingException {
        List<String> jarFiles = plugin.getLibraries();
        URL[] urls = new URL[jarFiles.size()];
        for (int i = 0; i < jarFiles.size(); ++i) {
            File jarfile = new File(jarFiles.get(i));
            urls[i] = new URL(URLDecoder.decode(jarfile.toURI().toURL().toString(), "UTF-8"));
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        String[] patterns = this.parentClassloaderPatternMap.get(plugin);
        if (patterns != null) {
            return new KettleSelectiveParentFirstClassLoader(urls, classLoader, plugin.getDescription(), patterns);
        }
        return new KettleURLClassLoader(urls, classLoader, plugin.getDescription());
    }

    private void addToClassLoader(PluginInterface plugin, KettleURLClassLoader ucl) throws MalformedURLException, UnsupportedEncodingException {
        String[] patterns = this.parentClassloaderPatternMap.get(plugin);
        if (ucl instanceof KettleSelectiveParentFirstClassLoader) {
            ((KettleSelectiveParentFirstClassLoader)ucl).addPatterns(patterns);
        }
        for (String jarFile : plugin.getLibraries()) {
            File jarfile = new File(jarFile);
            ucl.addURL(new URL(URLDecoder.decode(jarfile.toURI().toURL().toString(), "UTF-8")));
        }
    }

    public <T> void addClassFactory(Class<? extends PluginTypeInterface> pluginType, Class<T> tClass, String id, Callable<T> callable) throws KettlePluginException {
        String key = this.createSupplemantalKey(pluginType.getName(), id);
        SupplementalPlugin supplementalPlugin = (SupplementalPlugin)this.getPlugin(pluginType, key);
        if (supplementalPlugin == null) {
            supplementalPlugin = new SupplementalPlugin(pluginType, key);
            this.registerPlugin(pluginType, supplementalPlugin);
        }
        supplementalPlugin.addFactory(tClass, callable);
    }

    private String createSupplemantalKey(String pluginName, String id) {
        return pluginName + "-" + id + SUPPLEMENTALS_SUFFIX;
    }

    public <T> T loadClass(PluginInterface plugin, Class<T> pluginClass) throws KettlePluginException {
        if (plugin == null) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidStepOrPlugin.PLUGINREGISTRY001", new String[0]));
        }
        if (plugin instanceof ClassLoadingPluginInterface) {
            T aClass = ((ClassLoadingPluginInterface)((Object)plugin)).loadClass(pluginClass);
            if (aClass == null) {
                throw new KettlePluginClassMapException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidClassRequested.PLUGINREGISTRY002", plugin.getName(), pluginClass.getName()));
            }
            return aClass;
        }
        String className = plugin.getClassMap().get(pluginClass);
        if (className == null) {
            for (String id : plugin.getIds()) {
                try {
                    T aClass = this.loadClass(plugin.getPluginType(), this.createSupplemantalKey(plugin.getPluginType().getName(), id), pluginClass);
                    if (aClass == null) continue;
                    return aClass;
                }
                catch (KettlePluginException kettlePluginException) {
                    // empty catch block
                }
            }
            throw new KettlePluginClassMapException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidClassRequested.PLUGINREGISTRY002", plugin.getName(), pluginClass.getName()));
        }
        try {
            Class<?> cl;
            if (plugin.isNativePlugin()) {
                cl = Class.forName(className);
            } else {
                ClassLoader ucl = this.getClassLoader(plugin);
                cl = ucl.loadClass(className);
            }
            return (T)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.ClassNotFound.PLUGINREGISTRY003", new String[0]), e);
        }
        catch (InstantiationException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.UnableToInstantiateClass.PLUGINREGISTRY004", new String[0]), e);
        }
        catch (IllegalAccessException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.IllegalAccessToClass.PLUGINREGISTRY005", new String[0]), e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.UnExpectedErrorLoadingClass.PLUGINREGISTRY007", new String[0]), e);
        }
    }

    public static void addPluginType(PluginTypeInterface type) {
        pluginTypes.add(type);
    }

    public static List<PluginTypeInterface> getAddedPluginTypes() {
        ArrayList<PluginTypeInterface> temp = new ArrayList<PluginTypeInterface>(pluginTypes);
        return Collections.unmodifiableList(temp);
    }

    public static void init() throws KettlePluginException {
        PluginRegistry.init(false);
    }

    public static void init(boolean keepCache) throws KettlePluginException {
        PluginRegistry registry = PluginRegistry.getInstance();
        log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_REGISTER_EXTENSIONS_START, new long[0]);
        try {
            registry.registerType(PluginRegistryPluginType.getInstance());
            List plugins = registry.getPlugins(PluginRegistryPluginType.class);
            for (PluginInterface extensionPlugin : plugins) {
                log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_REGISTER_EXTENSION_START, extensionPlugin.getName(), new long[0]);
                PluginRegistryExtension extension = (PluginRegistryExtension)registry.loadClass(extensionPlugin);
                extension.init(registry);
                extensions.add(extension);
                log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_REGISTER_EXTENSIONS_STOP, extensionPlugin.getName(), new long[0]);
            }
        }
        catch (KettlePluginException e) {
            e.printStackTrace();
        }
        log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_REGISTER_EXTENSIONS_STOP, new long[0]);
        log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_PLUGIN_REGISTRATION_START, new long[0]);
        for (PluginTypeInterface pluginType : pluginTypes) {
            log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_PLUGIN_TYPE_REGISTRATION_START, pluginType.getName(), new long[0]);
            registry.registerType(pluginType);
            log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_PLUGIN_TYPE_REGISTRATION_STOP, pluginType.getName(), new long[0]);
        }
        log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_PLUGIN_REGISTRATION_STOP, new long[0]);
        if (!keepCache) {
            JarFileCache.getInstance().clear();
        }
    }

    private void registerType(PluginTypeInterface pluginType) throws KettlePluginException {
        this.registerPluginType(pluginType.getClass());
        long startScan = System.currentTimeMillis();
        pluginType.searchPlugins();
        for (PluginRegistryExtension ext : extensions) {
            ext.searchForType(pluginType);
        }
        HashSet pluginClassNames = new HashSet();
        String pluginClasses = EnvUtil.getSystemProperty("KETTLE_PLUGIN_CLASSES");
        if (!Utils.isEmpty(pluginClasses)) {
            String[] classNames = pluginClasses.split(",");
            Collections.addAll(pluginClassNames, classNames);
        }
        for (String className : pluginClassNames) {
            try {
                PluginAnnotationType annotationType = pluginType.getClass().getAnnotation(PluginAnnotationType.class);
                if (annotationType != null) {
                    Class<? extends Annotation> annotationClass = annotationType.value();
                    Class<?> clazz = Class.forName(className);
                    Annotation annotation = clazz.getAnnotation(annotationClass);
                    if (annotation != null) {
                        pluginType.handlePluginAnnotation(clazz, annotation, new ArrayList<String>(), true, null);
                        LogChannel.GENERAL.logBasic("Plugin class " + className + " registered for plugin type '" + pluginType.getName() + "'");
                        continue;
                    }
                    if (!KettleLogStore.isInitialized() || !LogChannel.GENERAL.isDebug()) continue;
                    LogChannel.GENERAL.logDebug("Plugin class " + className + " doesn't contain annotation for plugin type '" + pluginType.getName() + "'");
                    continue;
                }
                if (!KettleLogStore.isInitialized() || !LogChannel.GENERAL.isDebug()) continue;
                LogChannel.GENERAL.logDebug("Plugin class " + className + " doesn't contain valid class for plugin type '" + pluginType.getName() + "'");
            }
            catch (Exception e) {
                if (!KettleLogStore.isInitialized()) continue;
                LogChannel.GENERAL.logError("Error registring plugin class from KETTLE_PLUGIN_CLASSES: " + className + Const.CR + Const.getStackTracker(e));
            }
        }
        if (LogChannel.GENERAL.isDetailed()) {
            LogChannel.GENERAL.logDetailed("Registered " + this.getPlugins(pluginType.getClass()).size() + " plugins of type '" + pluginType.getName() + "' in " + (System.currentTimeMillis() - startScan) + "ms.");
        }
    }

    public String getPluginId(Object pluginClass) {
        return this.getPluginTypes().stream().map(pluginType -> this.getPluginId((Class<? extends PluginTypeInterface>)pluginType, pluginClass)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String getPluginId(Class<? extends PluginTypeInterface> pluginType, Object pluginClass) {
        String className = pluginClass.getClass().getName();
        PluginInterface plugin = this.getPlugins(pluginType).stream().filter(p -> p.getClassMap().values().contains(className)).findFirst().orElse(null);
        if (plugin != null) {
            return plugin.getIds()[0];
        }
        return extensions.stream().map(ext -> ext.getPluginId(pluginType, pluginClass)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public PluginInterface getPlugin(Class<? extends PluginTypeInterface> pluginType, Object pluginClass) {
        String pluginId = this.getPluginId(pluginType, pluginClass);
        if (pluginId == null) {
            return null;
        }
        return this.getPlugin(pluginType, pluginId);
    }

    public PluginInterface findPluginWithName(Class<? extends PluginTypeInterface> pluginType, String pluginName) {
        return this.getPlugins(pluginType).stream().filter(plugin -> plugin.getName().equals(pluginName)).findFirst().orElse(null);
    }

    public PluginInterface findPluginWithDescription(Class<? extends PluginTypeInterface> pluginType, String pluginDescription) {
        return this.getPlugins(pluginType).stream().filter(plugin -> plugin.getDescription().equals(pluginDescription)).findFirst().orElse(null);
    }

    public PluginInterface findPluginWithId(Class<? extends PluginTypeInterface> pluginType, String pluginId) {
        return this.getPlugin(pluginType, pluginId);
    }

    public List<String> getPluginPackages(Class<? extends PluginTypeInterface> pluginType) {
        TreeSet<String> list = new TreeSet<String>();
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            for (String className : plugin.getClassMap().values()) {
                int lastIndex = className.lastIndexOf(".");
                if (lastIndex <= -1) continue;
                list.add(className.substring(0, lastIndex));
            }
        }
        return new ArrayList<String>(list);
    }

    private RowMetaInterface getPluginInformationRowMeta() {
        RowMeta row = new RowMeta();
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.Type.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.ID.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.Name.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.Description.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.Libraries.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.ImageFile.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.ClassName.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.Category.Label", new String[0])));
        return row;
    }

    public RowBuffer getPluginInformation(Class<? extends PluginTypeInterface> pluginType) throws KettlePluginException {
        RowBuffer rowBuffer = new RowBuffer(this.getPluginInformationRowMeta());
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            Object[] row = new Object[this.getPluginInformationRowMeta().size()];
            int rowIndex = 0;
            row[rowIndex++] = this.getPluginType(plugin.getPluginType()).getName();
            row[rowIndex++] = plugin.getIds()[0];
            row[rowIndex++] = plugin.getName();
            row[rowIndex++] = Const.NVL(plugin.getDescription(), "");
            row[rowIndex++] = Utils.isEmpty(plugin.getLibraries()) ? "" : plugin.getLibraries().toString();
            row[rowIndex++] = Const.NVL(plugin.getImageFile(), "");
            row[rowIndex++] = plugin.getClassMap().values().toString();
            row[rowIndex] = Const.NVL(plugin.getCategory(), "");
            rowBuffer.getBuffer().add(row);
        }
        return rowBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getClass(PluginInterface plugin, String className) throws KettlePluginException {
        try {
            URLClassLoader ucl;
            if (plugin.isNativePlugin()) {
                return (T)Class.forName(className);
            }
            if (plugin instanceof ClassLoadingPluginInterface) {
                return (T)((ClassLoadingPluginInterface)((Object)plugin)).getClassLoader().loadClass(className);
            }
            this.lock.writeLock().lock();
            try {
                Map classLoaders = this.classLoaderMap.computeIfAbsent(plugin.getPluginType(), k -> new HashMap());
                ucl = (URLClassLoader)classLoaders.get(plugin);
                if (ucl == null) {
                    ucl = !Utils.isEmpty(plugin.getClassLoaderGroup()) ? this.classLoaderGroupsMap.get(plugin.getClassLoaderGroup()) : this.folderBasedClassLoaderMap.get(plugin.getPluginDirectory().toString());
                }
                if (ucl != null) {
                    classLoaders.put(plugin, ucl);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            if (ucl == null) {
                throw new KettlePluginException("Unable to find class loader for plugin: " + plugin);
            }
            return (T)ucl.loadClass(className);
        }
        catch (Exception e) {
            throw new KettlePluginException("Unexpected error loading class with name: " + className, e);
        }
    }

    public <T> T getClass(PluginInterface plugin, T classType) throws KettlePluginException {
        String className = plugin.getClassMap().get(classType);
        return (T)this.getClass(plugin, (T)className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassLoader getClassLoader(PluginInterface plugin) throws KettlePluginException {
        if (plugin == null) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidStepOrPlugin.PLUGINREGISTRY001", new String[0]));
        }
        try {
            if (plugin.isNativePlugin()) {
                return this.getClass().getClassLoader();
            }
            this.lock.writeLock().lock();
            try {
                URLClassLoader ucl;
                if (plugin.isSeparateClassLoaderNeeded()) {
                    ucl = this.createClassLoader(plugin);
                    return ucl;
                }
                Map classLoaders = this.classLoaderMap.computeIfAbsent(plugin.getPluginType(), k -> new HashMap());
                ucl = (URLClassLoader)classLoaders.get(plugin);
                if (ucl != null) return ucl;
                if (!Utils.isEmpty(plugin.getClassLoaderGroup())) {
                    ucl = this.classLoaderGroupsMap.get(plugin.getClassLoaderGroup());
                    if (ucl == null) {
                        ucl = this.createClassLoader(plugin);
                        classLoaders.put(plugin, ucl);
                        this.inverseClassLoaderLookup.computeIfAbsent(ucl, k -> new HashSet()).add(plugin);
                        this.classLoaderGroupsMap.put(plugin.getClassLoaderGroup(), ucl);
                        return ucl;
                    }
                    try {
                        ucl.loadClass(plugin.getClassMap().values().iterator().next());
                        return ucl;
                    }
                    catch (ClassNotFoundException ignored) {
                        this.addToClassLoader(plugin, (KettleURLClassLoader)ucl);
                        return ucl;
                    }
                }
                if (plugin.getPluginDirectory() != null) {
                    ucl = this.folderBasedClassLoaderMap.get(plugin.getPluginDirectory().toString());
                    if (ucl == null) {
                        ucl = this.createClassLoader(plugin);
                        classLoaders.put(plugin, ucl);
                        this.inverseClassLoaderLookup.computeIfAbsent(ucl, k -> new HashSet()).add(plugin);
                        this.folderBasedClassLoaderMap.put(plugin.getPluginDirectory().toString(), ucl);
                        return ucl;
                    }
                    try {
                        ucl.loadClass(plugin.getClassMap().values().iterator().next());
                        return ucl;
                    }
                    catch (ClassNotFoundException ignored) {
                        this.addToClassLoader(plugin, (KettleURLClassLoader)ucl);
                        return ucl;
                    }
                }
                ucl = (URLClassLoader)classLoaders.get(plugin);
                if (ucl != null) return ucl;
                if (plugin.getLibraries().size() == 0 && plugin instanceof ClassLoadingPluginInterface) {
                    ClassLoader classLoader = ((ClassLoadingPluginInterface)((Object)plugin)).getClassLoader();
                    return classLoader;
                }
                ucl = this.createClassLoader(plugin);
                classLoaders.put(plugin, ucl);
                this.inverseClassLoaderLookup.computeIfAbsent(ucl, k -> new HashSet()).add(plugin);
                return ucl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (MalformedURLException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.MalformedURL.PLUGINREGISTRY006", new String[0]), e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.UnExpectedCreatingClassLoader.PLUGINREGISTRY008", new String[0]), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PluginTypeInterface> void addPluginListener(Class<T> typeToTrack, PluginTypeListener listener) {
        this.lock.writeLock().lock();
        try {
            Set list = this.listeners.computeIfAbsent(typeToTrack, k -> new HashSet());
            list.add(listener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassLoader(URLClassLoader ucl, PluginInterface plugin) {
        this.lock.writeLock().lock();
        try {
            Map classLoaders = this.classLoaderMap.computeIfAbsent(plugin.getPluginType(), k -> new HashMap());
            classLoaders.put(plugin, ucl);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public PluginTypeInterface getPluginType(Class<? extends PluginTypeInterface> pluginTypeClass) throws KettlePluginException {
        try {
            Method method = pluginTypeClass.getMethod("getInstance", new Class[0]);
            return (PluginTypeInterface)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new KettlePluginException("Unable to get instance of plugin type: " + pluginTypeClass.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PluginInterface> findPluginsByFolder(URL folder) {
        String path = folder.getPath();
        try {
            path = folder.toURI().normalize().getPath();
        }
        catch (URISyntaxException e) {
            log.logError(e.getLocalizedMessage(), e);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        ArrayList<PluginInterface> result = new ArrayList<PluginInterface>();
        this.lock.readLock().lock();
        try {
            for (Set<PluginInterface> typeInterfaces : this.pluginMap.values()) {
                for (PluginInterface plugin : typeInterfaces) {
                    URL pluginFolder = plugin.getPluginDirectory();
                    try {
                        if (pluginFolder == null || !pluginFolder.toURI().normalize().getPath().startsWith(path)) continue;
                        result.add(plugin);
                    }
                    catch (URISyntaxException e) {
                        log.logError(e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public void reset() {
        this.lock.writeLock().lock();
        try {
            pluginTypes.clear();
            extensions.clear();
            this.pluginMap.clear();
            this.classLoaderMap.clear();
            this.classLoaderGroupsMap.clear();
            this.folderBasedClassLoaderMap.clear();
            this.inverseClassLoaderLookup.forEach((key, value) -> {
                try {
                    key.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            this.inverseClassLoaderLookup.clear();
            this.categoryMap.clear();
            this.parentClassloaderPatternMap.clear();
            this.listeners.clear();
            JarFileCache.getInstance().clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public PluginInterface findPluginWithId(Class<? extends PluginTypeInterface> pluginType, String pluginId, boolean waitForPluginToBeAvailable) {
        PluginInterface pluginInterface = this.findPluginWithId(pluginType, pluginId);
        return waitForPluginToBeAvailable && pluginInterface == null ? this.waitForPluginToBeAvailable(pluginType, pluginId, 3000) : pluginInterface;
    }

    private PluginInterface waitForPluginToBeAvailable(Class<? extends PluginTypeInterface> pluginType, String pluginId, int waitLimit) {
        int timeToSleep = 50;
        try {
            Thread.sleep(timeToSleep);
        }
        catch (InterruptedException e) {
            log.logError(e.getLocalizedMessage(), e);
            Thread.currentThread().interrupt();
            return null;
        }
        PluginInterface pluginInterface = this.findPluginWithId(pluginType, pluginId);
        return (waitLimit -= timeToSleep) <= 0 && pluginInterface == null ? null : (pluginInterface != null ? pluginInterface : this.waitForPluginToBeAvailable(pluginType, pluginId, waitLimit));
    }
}

