/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;

public class PluginFolder
implements PluginFolderInterface {
    private String folder;
    private boolean pluginXmlFolder;
    private boolean pluginAnnotationsFolder;
    private boolean searchLibDir;

    public PluginFolder(String folder, boolean pluginXmlFolder, boolean pluginAnnotationsFolder) {
        this(folder, pluginXmlFolder, pluginAnnotationsFolder, false);
    }

    public PluginFolder(String folder, boolean pluginXmlFolder, boolean pluginAnnotationsFolder, boolean searchLibDir) {
        this.folder = folder;
        this.pluginXmlFolder = pluginXmlFolder;
        this.pluginAnnotationsFolder = pluginAnnotationsFolder;
        this.searchLibDir = searchLibDir;
    }

    public String toString() {
        return this.folder;
    }

    public static List<PluginFolderInterface> populateFolders(String xmlSubfolder) {
        String[] folders;
        ArrayList<PluginFolderInterface> pluginFolders = new ArrayList<PluginFolderInterface>();
        String folderPaths = EnvUtil.getSystemProperty("BI_KETTLE_PLUGIN_BASE_FOLDERS");
        if (folderPaths == null) {
            folderPaths = Const.DEFAULT_PLUGIN_BASE_FOLDERS;
        }
        for (String folder : folders = folderPaths.split(",")) {
            folder = folder.trim();
            pluginFolders.add(new PluginFolder(folder, false, true));
            if (Utils.isEmpty(xmlSubfolder)) continue;
            pluginFolders.add(new PluginFolder(folder + File.separator + xmlSubfolder, true, false));
        }
        return pluginFolders;
    }

    @Override
    public FileObject[] findJarFiles() throws KettleFileException {
        return this.findJarFiles(this.searchLibDir);
    }

    public FileObject[] findJarFiles(final boolean includeLibJars) throws KettleFileException {
        try {
            FileObject folderObject = KettleVFS.getFileObject(this.getFolder());
            return folderObject.findFiles(new FileSelector(){

                public boolean traverseDescendents(FileSelectInfo fileSelectInfo) throws Exception {
                    FileObject fileObject = fileSelectInfo.getFile();
                    String folder = fileObject.getName().getBaseName();
                    FileObject kettleIgnore = fileObject.getChild(".kettle-ignore");
                    return includeLibJars || kettleIgnore == null && !"lib".equals(folder);
                }

                public boolean includeFile(FileSelectInfo fileSelectInfo) throws Exception {
                    FileObject file = fileSelectInfo.getFile();
                    return file.isFile() && file.toString().endsWith(".jar");
                }
            });
        }
        catch (Exception e) {
            throw new KettleFileException("Unable to list jar files in plugin folder '" + this.toString() + "'", e);
        }
    }

    @Override
    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    @Override
    public boolean isPluginXmlFolder() {
        return this.pluginXmlFolder;
    }

    public void setPluginXmlFolder(boolean pluginXmlFolder) {
        this.pluginXmlFolder = pluginXmlFolder;
    }

    @Override
    public boolean isPluginAnnotationsFolder() {
        return this.pluginAnnotationsFolder;
    }

    public void setPluginAnnotationsFolder(boolean pluginAnnotationsFolder) {
        this.pluginAnnotationsFolder = pluginAnnotationsFolder;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.folder).append(this.pluginAnnotationsFolder).append(this.pluginXmlFolder).append(this.searchLibDir).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PluginFolder other = (PluginFolder)obj;
        return new EqualsBuilder().append((Object)this.folder, (Object)other.getFolder()).append(this.pluginAnnotationsFolder, other.isPluginAnnotationsFolder()).append(this.pluginXmlFolder, other.isPluginXmlFolder()).append(this.searchLibDir, other.searchLibDir).isEquals();
    }
}

