/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pentaho.di.core.plugins.KettleURLClassLoader;

public class KettleSelectiveParentFirstClassLoader
extends KettleURLClassLoader {
    private List<Pattern> patterns = new ArrayList<Pattern>();

    public KettleSelectiveParentFirstClassLoader(URL[] url, ClassLoader classLoader, String[] patterns) {
        super(url, classLoader);
        this.addPatterns(patterns);
    }

    public KettleSelectiveParentFirstClassLoader(URL[] url, ClassLoader classLoader, String name, String[] patterns) {
        super(url, classLoader, name);
        this.addPatterns(patterns);
    }

    public void addPatterns(String[] patterns) {
        if (patterns != null) {
            this.patterns.addAll(Arrays.stream(patterns).map(Pattern::compile).collect(Collectors.toList()));
        }
    }

    private Class<?> loadClassParentFirst(String arg0, boolean arg1) throws ClassNotFoundException {
        try {
            return this.loadClassFromParent(arg0, arg1);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return this.loadClassFromThisLoader(arg0, arg1);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(arg0).matches()) continue;
            return this.loadClassParentFirst(arg0, arg1);
        }
        return super.loadClass(arg0, arg1);
    }
}

