/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.Date;
import java.util.Map;
import java.util.Queue;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.LogChannelFileWriterBuffer;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogMessage;
import org.pentaho.di.core.logging.LogMessageInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.logging.MetricsInterface;
import org.pentaho.di.core.logging.MetricsRegistry;
import org.pentaho.di.core.metrics.MetricsSnapshot;
import org.pentaho.di.core.metrics.MetricsSnapshotInterface;
import org.pentaho.di.core.metrics.MetricsSnapshotType;
import org.pentaho.di.core.util.Utils;

public class LogChannel
implements LogChannelInterface {
    public static final LogChannelInterface GENERAL = new LogChannel((Object)"General", false, false);
    public static final LogChannelInterface METADATA = new LogChannel((Object)"Metadata", false, false);
    public static final LogChannelInterface UI = new LogChannel((Object)"GUI", false, false);
    private String logChannelId;
    private LogLevel logLevel;
    private String containerObjectId;
    private boolean gatheringMetrics;
    private boolean forcingSeparateLogging;
    private static MetricsRegistry metricsRegistry = MetricsRegistry.getInstance();
    private String filter;
    private LogChannelFileWriterBuffer fileWriter;

    public LogChannel(Object subject) {
        this.logLevel = DefaultLogLevel.getLogLevel();
        this.logChannelId = LoggingRegistry.getInstance().registerLoggingSource(subject);
    }

    public LogChannel(Object subject, boolean gatheringMetrics) {
        this(subject);
        this.gatheringMetrics = gatheringMetrics;
    }

    public LogChannel(Object subject, boolean gatheringMetrics, boolean isPurgeable) {
        this.logLevel = DefaultLogLevel.getLogLevel();
        this.gatheringMetrics = gatheringMetrics;
        this.logChannelId = LoggingRegistry.getInstance().registerLoggingSource(subject, isPurgeable);
    }

    public LogChannel(Object subject, LoggingObjectInterface parentObject) {
        if (parentObject != null) {
            this.logLevel = parentObject.getLogLevel();
            this.containerObjectId = parentObject.getContainerObjectId();
        } else {
            this.logLevel = DefaultLogLevel.getLogLevel();
            this.containerObjectId = null;
        }
        this.logChannelId = LoggingRegistry.getInstance().registerLoggingSource(subject);
    }

    public LogChannel(Object subject, LoggingObjectInterface parentObject, boolean gatheringMetrics) {
        this(subject, parentObject);
        this.gatheringMetrics = gatheringMetrics;
    }

    public String toString() {
        return this.logChannelId;
    }

    @Override
    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void println(LogMessageInterface logMessage, LogLevel channelLogLevel) {
        String subject = null;
        LogLevel logLevel = logMessage.getLevel();
        if (!logLevel.isVisible(channelLogLevel)) {
            return;
        }
        if (subject == null) {
            subject = "Kettle";
        }
        if (!logLevel.isError() && !Utils.isEmpty(this.filter) && subject.indexOf(this.filter) < 0 && logMessage.toString().indexOf(this.filter) < 0) {
            return;
        }
        if (channelLogLevel.getLevel() >= logLevel.getLevel()) {
            KettleLoggingEvent loggingEvent = new KettleLoggingEvent(logMessage, System.currentTimeMillis(), logLevel);
            KettleLogStore.getAppender().addLogggingEvent(loggingEvent);
            if (this.fileWriter == null) {
                this.fileWriter = LoggingRegistry.getInstance().getLogChannelFileWriterBuffer(this.logChannelId);
            }
            if (this.fileWriter != null) {
                this.fileWriter.addEvent(loggingEvent);
            }
        }
    }

    public void println(LogMessageInterface message, Throwable e, LogLevel channelLogLevel) {
        this.println(message, channelLogLevel);
        String stackTrace = Const.getStackTracker(e);
        LogMessage traceMessage = new LogMessage(stackTrace, message.getLogChannelId(), LogLevel.ERROR);
        this.println(traceMessage, channelLogLevel);
    }

    @Override
    public void logMinimal(String s) {
        this.println(new LogMessage(s, this.logChannelId, LogLevel.MINIMAL), this.logLevel);
    }

    @Override
    public void logBasic(String s) {
        this.println(new LogMessage(s, this.logChannelId, LogLevel.BASIC), this.logLevel);
    }

    @Override
    public void logError(String s) {
        this.println(new LogMessage(s, this.logChannelId, LogLevel.ERROR), this.logLevel);
    }

    @Override
    public void logError(String s, Throwable e) {
        this.println(new LogMessage(s, this.logChannelId, LogLevel.ERROR), e, this.logLevel);
    }

    @Override
    public void logBasic(String s, Object ... arguments) {
        this.println(new LogMessage(s, this.logChannelId, arguments, LogLevel.BASIC), this.logLevel);
    }

    @Override
    public void logDetailed(String s, Object ... arguments) {
        this.println(new LogMessage(s, this.logChannelId, arguments, LogLevel.DETAILED), this.logLevel);
    }

    @Override
    public void logError(String s, Object ... arguments) {
        this.println(new LogMessage(s, this.logChannelId, arguments, LogLevel.ERROR), this.logLevel);
    }

    @Override
    public void logDetailed(String s) {
        this.println(new LogMessage(s, this.logChannelId, LogLevel.DETAILED), this.logLevel);
    }

    @Override
    public void logDebug(String s) {
        this.println(new LogMessage(s, this.logChannelId, LogLevel.DEBUG), this.logLevel);
    }

    @Override
    public void logDebug(String message, Object ... arguments) {
        this.println(new LogMessage(message, this.logChannelId, arguments, LogLevel.DEBUG), this.logLevel);
    }

    @Override
    public void logRowlevel(String s) {
        this.println(new LogMessage(s, this.logChannelId, LogLevel.ROWLEVEL), this.logLevel);
    }

    @Override
    public void logMinimal(String message, Object ... arguments) {
        this.println(new LogMessage(message, this.logChannelId, arguments, LogLevel.MINIMAL), this.logLevel);
    }

    @Override
    public void logRowlevel(String message, Object ... arguments) {
        this.println(new LogMessage(message, this.logChannelId, arguments, LogLevel.ROWLEVEL), this.logLevel);
    }

    @Override
    public boolean isBasic() {
        return this.logLevel.isBasic();
    }

    @Override
    public boolean isDebug() {
        return this.logLevel.isDebug();
    }

    @Override
    public boolean isDetailed() {
        try {
            return this.logLevel.isDetailed();
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    @Override
    public boolean isRowLevel() {
        return this.logLevel.isRowlevel();
    }

    @Override
    public boolean isError() {
        return this.logLevel.isError();
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public String getContainerObjectId() {
        return this.containerObjectId;
    }

    @Override
    public void setContainerObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }

    @Override
    public boolean isGatheringMetrics() {
        return this.gatheringMetrics;
    }

    @Override
    public void setGatheringMetrics(boolean gatheringMetrics) {
        this.gatheringMetrics = gatheringMetrics;
    }

    @Override
    public boolean isForcingSeparateLogging() {
        return this.forcingSeparateLogging;
    }

    @Override
    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        this.forcingSeparateLogging = forcingSeparateLogging;
    }

    @Override
    public void snap(MetricsInterface metric, long ... value) {
        this.snap(metric, null, value);
    }

    @Override
    public void snap(MetricsInterface metric, String subject, long ... value) {
        if (!this.isGatheringMetrics()) {
            return;
        }
        String key = MetricsSnapshot.getKey(metric, subject);
        Map<String, MetricsSnapshotInterface> metricsMap = null;
        MetricsSnapshotInterface snapshot = null;
        Queue<MetricsSnapshotInterface> metricsList = null;
        switch (metric.getType()) {
            case MAX: {
                if (value.length != 1) break;
                metricsMap = metricsRegistry.getSnapshotMap(this.logChannelId);
                snapshot = metricsMap.get(key);
                if (snapshot != null) {
                    if (value[0] <= snapshot.getValue()) break;
                    snapshot.setValue(value[0]);
                    snapshot.setDate(new Date());
                    break;
                }
                snapshot = new MetricsSnapshot(MetricsSnapshotType.MAX, metric, subject, value[0], this.logChannelId);
                metricsMap.put(key, snapshot);
                break;
            }
            case MIN: {
                if (value.length != 1) break;
                metricsMap = metricsRegistry.getSnapshotMap(this.logChannelId);
                snapshot = metricsMap.get(key);
                if (snapshot != null) {
                    if (value[0] >= snapshot.getValue()) break;
                    snapshot.setValue(value[0]);
                    snapshot.setDate(new Date());
                    break;
                }
                snapshot = new MetricsSnapshot(MetricsSnapshotType.MIN, metric, subject, value[0], this.logChannelId);
                metricsMap.put(key, snapshot);
                break;
            }
            case SUM: {
                metricsMap = metricsRegistry.getSnapshotMap(this.logChannelId);
                snapshot = metricsMap.get(key);
                if (snapshot != null) {
                    snapshot.setValue(snapshot.getValue() + value[0]);
                    break;
                }
                snapshot = new MetricsSnapshot(MetricsSnapshotType.SUM, metric, subject, value[0], this.logChannelId);
                metricsMap.put(key, snapshot);
                break;
            }
            case COUNT: {
                metricsMap = metricsRegistry.getSnapshotMap(this.logChannelId);
                snapshot = metricsMap.get(key);
                if (snapshot != null) {
                    snapshot.setValue(snapshot.getValue() + 1L);
                    break;
                }
                snapshot = new MetricsSnapshot(MetricsSnapshotType.COUNT, metric, subject, 1L, this.logChannelId);
                metricsMap.put(key, snapshot);
                break;
            }
            case START: {
                metricsList = metricsRegistry.getSnapshotList(this.logChannelId);
                snapshot = new MetricsSnapshot(MetricsSnapshotType.START, metric, subject, 1L, this.logChannelId);
                metricsList.add(snapshot);
                break;
            }
            case STOP: {
                metricsList = metricsRegistry.getSnapshotList(this.logChannelId);
                snapshot = new MetricsSnapshot(MetricsSnapshotType.STOP, metric, subject, 1L, this.logChannelId);
                metricsList.add(snapshot);
                break;
            }
        }
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
    }
}

