/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.encryption;

import org.eclipse.jetty.util.security.Password;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderInterface;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.util.Utils;

public class Encr {
    private static TwoWayPasswordEncoderInterface encoder;
    public static final String PASSWORD_ENCRYPTED_PREFIX = "Encrypted ";

    @Deprecated
    public boolean init() {
        return true;
    }

    public static void init(String encoderPluginId) throws KettleException {
        if (Utils.isEmpty(encoderPluginId)) {
            throw new KettleException("Unable to initialize the two way password encoder: No encoder plugin type specified.");
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.findPluginWithId(TwoWayPasswordEncoderPluginType.class, encoderPluginId);
        if (plugin == null) {
            throw new KettleException("Unable to find plugin with ID '" + encoderPluginId + "'");
        }
        encoder = (TwoWayPasswordEncoderInterface)registry.loadClass(plugin);
        encoder.init();
    }

    @Deprecated
    public static final boolean checkSignatureShort(String signature, String verify) {
        return Encr.getSignatureShort(signature).equalsIgnoreCase(verify);
    }

    @Deprecated
    public static final String getSignatureShort(String signature) {
        String retval = "";
        if (signature == null) {
            return retval;
        }
        int len = signature.length();
        if (len < 6) {
            return retval;
        }
        retval = signature.substring(len - 5, len);
        return retval;
    }

    public static final String encryptPassword(String password) {
        return encoder.encode(password, false);
    }

    public static final String decryptPassword(String encrypted) {
        return encoder.decode(encrypted);
    }

    public static final String encryptPasswordIfNotUsingVariables(String password) {
        return encoder.encode(password, true);
    }

    public static final String decryptPasswordOptionallyEncrypted(String password) {
        return encoder.decode(password, true);
    }

    public static void main(String[] args) throws KettleException {
        KettleClientEnvironment.init();
        if (args.length != 2) {
            Encr.printOptions();
            System.exit(9);
        }
        String option = args[0];
        String password = args[1];
        if (Const.trim(option).substring(1).equalsIgnoreCase("kettle")) {
            try {
                String obfuscated = Encr.encryptPasswordIfNotUsingVariables(password);
                System.out.println(obfuscated);
                System.exit(0);
            }
            catch (Exception ex) {
                System.err.println("Error encrypting password");
                ex.printStackTrace();
                System.exit(2);
            }
        } else if (Const.trim(option).substring(1).equalsIgnoreCase("carte")) {
            String obfuscated = Password.obfuscate((String)password);
            System.out.println(obfuscated);
            System.exit(0);
        } else {
            System.err.println("Unknown option '" + option + "'\n");
            Encr.printOptions();
            System.exit(1);
        }
    }

    private static void printOptions() {
        System.err.println("encr usage:\n");
        System.err.println("  encr <-kettle|-carte> <password>");
        System.err.println("  Options:");
        System.err.println("    -kettle: generate an obfuscated password to include in Kettle XML files");
        System.err.println("    -carte : generate an obfuscated password to include in the carte password file 'pwd/kettle.pwd'");
        System.err.println("\nThis command line tool obfuscates a plain text password for use in XML and password files.");
        System.err.println("Make sure to also copy the 'Encrypted ' prefix to indicate the obfuscated nature of the password.");
        System.err.println("Kettle will then be able to make the distinction between regular plain text passwords and obfuscated ones.");
        System.err.println();
    }
}

