/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;

public class MonetDBDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public static ThreadLocal<Boolean> safeModeLocal = new ThreadLocal();
    public static final int DEFAULT_VARCHAR_LENGTH = 100;
    protected static final String FIELDNAME_PROTECTOR = "_";
    private static final int MAX_VARCHAR_LENGTH = Integer.MAX_VALUE;

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 50000;
        }
        return -1;
    }

    @Override
    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 0) {
            return "nl.cwi.monetdb.jdbc.MonetDriver";
        }
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 0) {
            if (Utils.isEmpty(port)) {
                return "jdbc:monetdb://" + hostname + "/" + databaseName;
            }
            return "jdbc:monetdb://" + hostname + ":" + port + "/" + databaseName;
        }
        return "jdbc:odbc:" + databaseName;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return false;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return true;
    }

    @Override
    public boolean supportsAutoInc() {
        return true;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public boolean supportsSetMaxRows() {
        return true;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"IS", "ISNULL", "NOTNULL", "IN", "BETWEEN", "OVERLAPS", "LIKE", "ILIKE", "NOT", "AND", "OR", "CHAR", "VARCHAR", "CLOB", "BLOB", "DECIMAL", "DEC", "NUMERIC", "TINYINT", "SMALLINT", "INT", "BIGINT", "REAL", "DOUBLE", "BOOLEAN", "DATE", "TIME", "TIMESTAMP", "INTERVAL", "YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "TIMEZONE", "EXTRACT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "LOCALTIME", "LOCALTIMESTAMP", "CURRENT_TIME", "SERIAL", "START", "WITH", "INCREMENT", "CACHE", "CYCLE", "SEQUENCE", "GETANCHOR", "GETBASENAME", "GETCONTENT", "GETCONTEXT", "GETDOMAIN", "GETEXTENSION", "GETFILE", "GETHOST", "GETPORT", "GETPROTOCOL", "GETQUERY", "GETUSER", "GETROBOTURL", "ISURL", "NEWURL", "BROADCAST", "MASKLEN", "SETMASKLEN", "NETMASK", "HOSTMASK", "NETWORK", "TEXT", "ABBREV", "CREATE", "TYPE", "NAME", "DROP", "USER"};
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        boolean safeMode;
        StringBuilder retval = new StringBuilder();
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        Boolean mode = safeModeLocal.get();
        boolean bl = safeMode = mode != null && mode != false;
        if (add_fieldname) {
            if (safeMode) {
                fieldname = this.getSafeFieldname(fieldname);
            }
            retval.append(fieldname + " ");
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval.append("TIMESTAMP");
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval.append("BOOLEAN");
                    break;
                }
                retval.append("CHAR(1)");
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (use_autoinc) {
                        retval.append("SERIAL");
                        break;
                    }
                    retval.append("BIGINT");
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval.append("BIGINT");
                            break;
                        }
                        retval.append("DECIMAL(").append(length).append(")");
                        break;
                    }
                    if (type == 1) {
                        retval.append("DOUBLE");
                        break;
                    }
                    retval.append("BIGINT");
                    break;
                }
                if (length > 15) {
                    retval.append("DECIMAL(").append(length);
                    if (precision > 0) {
                        retval.append(", ").append(precision);
                    }
                    retval.append(")");
                    break;
                }
                retval.append("DOUBLE");
                break;
            }
            case 2: {
                if (length > this.getMaxVARCHARLength()) {
                    retval.append("CLOB");
                    break;
                }
                retval.append("VARCHAR(");
                if (length > 0) {
                    retval.append(length);
                } else if (safeMode) {
                    retval.append(100);
                }
                retval.append(")");
                break;
            }
            default: {
                retval.append(" UNKNOWN");
            }
        }
        if (add_cr) {
            retval.append(Const.CR);
        }
        return retval.toString();
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"monetdb-jdbc-2.8.jar"};
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + ";";
    }

    @Override
    public boolean supportsResultSetMetadataRetrievalOnly() {
        return true;
    }

    @Override
    public int getMaxVARCHARLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getSQLListOfSequences() {
        return "SELECT name FROM sys.sequences";
    }

    @Override
    public String getSQLSequenceExists(String sequenceName) {
        return String.format("SELECT * FROM sys.sequences WHERE name = '%s'", sequenceName);
    }

    @Override
    public String getSQLCurrentSequenceValue(String sequenceName) {
        String realSequenceName = sequenceName.replace(this.getStartQuote(), "").replace(this.getEndQuote(), "");
        return String.format("SELECT get_value_for( 'sys', '%s' )", realSequenceName);
    }

    @Override
    public String getSQLNextSequenceValue(String sequenceName) {
        String realSequenceName = sequenceName.replace(this.getStartQuote(), "").replace(this.getEndQuote(), "");
        return String.format("SELECT next_value_for( 'sys', '%s' )", realSequenceName);
    }
}

