/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.connections.vfs.providers.other;

import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.pentaho.di.connections.vfs.BaseVFSConnectionProvider;
import org.pentaho.di.connections.vfs.VFSRoot;
import org.pentaho.di.connections.vfs.providers.other.OtherConnectionDetails;

public class OtherConnectionDetailsProvider
extends BaseVFSConnectionProvider<OtherConnectionDetails> {
    public static final String NAME = "Other";
    public static final String SCHEME = "other";

    @Override
    public Class<OtherConnectionDetails> getClassType() {
        return OtherConnectionDetails.class;
    }

    @Override
    public FileSystemOptions getOpts(OtherConnectionDetails otherConnectionDetails) {
        if (otherConnectionDetails == null) {
            return null;
        }
        StaticUserAuthenticator auth = new StaticUserAuthenticator(otherConnectionDetails.getHost(), otherConnectionDetails.getUsername(), otherConnectionDetails.getPassword());
        FileSystemOptions opts = new FileSystemOptions();
        try {
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)auth);
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return opts;
    }

    @Override
    public List<VFSRoot> getLocations(OtherConnectionDetails vfsConnectionDetails) {
        String host = vfsConnectionDetails.getHost();
        String port = vfsConnectionDetails.getPort();
        String location = host + (port != null && !port.equals("") ? ":" + port : "");
        return Collections.singletonList(new VFSRoot(location, null));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getKey() {
        return SCHEME;
    }

    @Override
    public String getProtocol(OtherConnectionDetails otherConnectionDetails) {
        return otherConnectionDetails.getProtocol();
    }

    @Override
    public boolean test(OtherConnectionDetails connectionDetails) {
        return true;
    }
}

