/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import org.pentaho.di.compatibility.ValueInterface;

public class ValueBigNumber
implements ValueInterface,
Cloneable {
    private BigDecimal number;
    private int length;
    private int precision;

    public ValueBigNumber() {
        this.number = null;
        this.length = -1;
        this.precision = -1;
    }

    public ValueBigNumber(BigDecimal number) {
        this.number = number;
        this.length = -1;
        this.precision = -1;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public Serializable getSerializable() {
        return this.number;
    }

    @Override
    public String getTypeDesc() {
        return "BigNumber";
    }

    @Override
    public String getString() {
        if (this.number == null) {
            return null;
        }
        return this.number.toString();
    }

    @Override
    public double getNumber() {
        if (this.number == null) {
            return 0.0;
        }
        return this.number.doubleValue();
    }

    @Override
    public Date getDate() {
        if (this.number == null) {
            return null;
        }
        return new Date(this.number.longValue());
    }

    @Override
    public boolean getBoolean() {
        if (this.number == null) {
            return false;
        }
        return this.number.longValue() != 0L;
    }

    @Override
    public long getInteger() {
        if (this.number == null) {
            return 0L;
        }
        return this.number.longValue();
    }

    @Override
    public void setString(String string) {
        try {
            this.number = new BigDecimal(string);
        }
        catch (NumberFormatException e) {
            this.number = BigDecimal.ZERO;
        }
    }

    @Override
    public void setNumber(double number) {
        this.number = BigDecimal.valueOf(number);
    }

    @Override
    public void setDate(Date date) {
        this.number = new BigDecimal(date.getTime());
    }

    @Override
    public void setBoolean(boolean bool) {
        this.number = bool ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public void setInteger(long number) {
        this.number = new BigDecimal(number);
    }

    @Override
    public void setSerializable(Serializable ser) {
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public void setLength(int length, int precision) {
        this.length = length;
        this.precision = precision;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public Object clone() {
        try {
            ValueBigNumber retval = (ValueBigNumber)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public BigDecimal getBigNumber() {
        return this.number;
    }

    @Override
    public void setBigNumber(BigDecimal number) {
        this.number = number;
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public void setBytes(byte[] b) {
    }
}

