/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jfor.jfor.main.JForVersionInfo;
import org.jfor.jfor.rtflib.rtfdoc.RtfColorTable;
import org.jfor.jfor.rtflib.rtfdoc.RtfContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfFile;
import org.jfor.jfor.rtflib.rtfdoc.RtfFontTable;
import org.jfor.jfor.rtflib.rtfdoc.RtfStringConverter;
import org.jfor.jfor.rtflib.rtfdoc.RtfStyleSheetTable;
import org.jfor.jfor.rtflib.rtfdoc.RtfTemplate;

class RtfHeader
extends RtfContainer {
    private final String m_charset = "ansi";
    private final Map m_userProperties = new HashMap();

    RtfHeader(RtfFile rtfFile, Writer writer) throws IOException {
        super(rtfFile, writer);
        new RtfFontTable(this, writer);
        this.m_userProperties.put("jforVersion", JForVersionInfo.getLongVersionInfo());
        this.m_userProperties.put("jforCreatedThisOn", new Date().toString());
    }

    protected void writeRtfContent() throws IOException {
        this.writeControlWord("ansi");
        this.writeUserProperties();
        RtfColorTable.getInstance().writeColors(this);
        super.writeRtfContent();
        RtfTemplate.getInstance().writeTemplate(this);
        RtfStyleSheetTable.getInstance().writeStyleSheet(this);
    }

    private void writeUserProperties() throws IOException {
        if (this.m_userProperties.size() > 0) {
            this.writeGroupMark(true);
            this.writeStarControlWord("userprops");
            Iterator iterator = this.m_userProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.writeGroupMark(true);
                this.writeControlWord("propname");
                RtfStringConverter.getInstance().writeRtfString(this.m_writer, entry.getKey().toString());
                this.writeGroupMark(false);
                this.writeControlWord("proptype30");
                this.writeGroupMark(true);
                this.writeControlWord("staticval");
                RtfStringConverter.getInstance().writeRtfString(this.m_writer, entry.getValue().toString());
                this.writeGroupMark(false);
            }
            this.writeGroupMark(false);
        }
    }

    void write(String string) throws IOException {
        this.m_writer.write(string);
    }

    void writeRtfString(String string) throws IOException {
        RtfStringConverter.getInstance().writeRtfString(this.m_writer, string);
    }
}

