/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.hibernate.spring;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.hibernate.spring.SpringHibernateDataAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpringHibernateDataAdapterService
extends AbstractDataAdapterService {
    private static final Log log = LogFactory.getLog(SpringHibernateDataAdapterService.class);
    private Object session;

    public SpringHibernateDataAdapterService(ParameterContributorContext paramContribContext, SpringHibernateDataAdapter jsonDataAdapter) {
        super(paramContribContext, (DataAdapter)jsonDataAdapter);
    }

    public SpringHibernateDataAdapter getHibernateDataAdapter() {
        return (SpringHibernateDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        SpringHibernateDataAdapter hbmDA = this.getHibernateDataAdapter();
        if (hbmDA != null) {
            try {
                Class<?> clazz = JRClassLoader.loadClassForRealName("org.springframework.context.support.ClassPathXmlApplicationContext");
                if (clazz != null) {
                    StringTokenizer parser = new StringTokenizer(hbmDA.getSpringConfig(), ",");
                    String[] configs = new String[parser.countTokens()];
                    int iCount = 0;
                    while (parser.hasMoreTokens()) {
                        configs[iCount++] = parser.nextToken();
                    }
                    Object configure = clazz.getConstructor(String[].class).newInstance(new Object[]{configs});
                    if (configure != null) {
                        Object bsf = clazz.getMethod("getBean", String.class).invoke(configure, hbmDA.getBeanId());
                        this.session = bsf.getClass().getMethod("openSession", new Class[0]).invoke(bsf, new Object[0]);
                        this.session.getClass().getMethod("beginTransaction", new Class[0]).invoke(this.session, new Object[0]);
                        parameters.put("HIBERNATE_SESSION", this.session);
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new JRException(e);
            }
        }
    }

    @Override
    public void dispose() {
        block3: {
            if (this.session != null) {
                try {
                    this.session.getClass().getMethod("close", new Class[0]).invoke(this.session, new Object[0]);
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Error while closing the connection.", (Throwable)ex);
                }
            }
        }
    }
}

