/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseMultiAxisPlot
extends JRBaseChartPlot
implements JRMultiAxisPlot {
    private static final long serialVersionUID = 10200L;
    protected List<JRChartAxis> axes = new ArrayList<JRChartAxis>();

    public JRBaseMultiAxisPlot(JRChartPlot multiAxisPlot, JRChart chart) {
        super(multiAxisPlot, chart);
    }

    public JRBaseMultiAxisPlot(JRMultiAxisPlot multiAxisPlot, JRBaseObjectFactory factory) {
        super((JRChartPlot)multiAxisPlot, factory);
        List<JRChartAxis> origAxes = multiAxisPlot.getAxes();
        this.axes.clear();
        if (origAxes != null) {
            for (JRChartAxis axis : origAxes) {
                this.axes.add(factory.getChartAxis(axis));
            }
        }
    }

    @Override
    public List<JRChartAxis> getAxes() {
        return this.axes;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        for (JRChartAxis axis : this.axes) {
            collector.collect(axis.getChart());
        }
    }

    @Override
    public Object clone(JRChart parentChart) {
        ArrayList<JRChartAxis> cloneAxes;
        JRBaseMultiAxisPlot clone = (JRBaseMultiAxisPlot)super.clone(parentChart);
        if (this.axes == null) {
            cloneAxes = null;
        } else {
            cloneAxes = new ArrayList<JRChartAxis>(this.axes.size());
            for (JRChartAxis axis : this.axes) {
                JRChartAxis axisClone = axis == null ? null : axis.clone(parentChart);
                cloneAxes.add(axisClone);
            }
        }
        clone.axes = cloneAxes;
        return clone;
    }
}

