/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.jcr.NamespaceException;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefReader;
import org.apache.jackrabbit.commons.cnd.DefinitionBuilderFactory;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.QDefinitionBuilderFactory;
import org.apache.jackrabbit.spi.commons.nodetype.compact.CompactNodeTypeDefWriter;
import org.apache.jackrabbit.spi.commons.privilege.ParseException;
import org.apache.jackrabbit.spi.commons.privilege.PrivilegeDefinitionReader;
import org.apache.jackrabbit.spi.commons.privilege.PrivilegeDefinitionWriter;

public abstract class AbstractRecord
implements Record {
    private static final byte UUID_LITERAL = 76;
    private static final byte UUID_INDEX = 73;
    private final BidiMap<NodeId, Integer> nodeIdIndex = new DualHashBidiMap();
    protected final NamespaceResolver nsResolver;
    protected final NamePathResolver resolver;

    public AbstractRecord(NamespaceResolver nsResolver, NamePathResolver resolver) {
        this.nsResolver = nsResolver;
        this.resolver = resolver;
    }

    @Override
    public void writeQName(Name name) throws JournalException {
        try {
            this.writeString(this.resolver.getJCRName(name));
        }
        catch (NamespaceException e) {
            String msg = "Undeclared prefix error while writing name.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void writePathElement(Path path) throws JournalException {
        this.writeQName(path.getName());
        this.writeInt(path.getIndex());
    }

    @Override
    public void writePath(Path path) throws JournalException {
        try {
            this.writeString(this.resolver.getJCRPath(path));
        }
        catch (NamespaceException e) {
            String msg = "Undeclared prefix error while writing path.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void writeNodeId(NodeId nodeId) throws JournalException {
        if (nodeId == null) {
            this.writeByte(73);
            this.writeInt(-1);
        } else {
            int index = this.getOrCreateIndex(nodeId);
            if (index != -1) {
                this.writeByte(73);
                this.writeInt(index);
            } else {
                this.writeByte(76);
                this.write(nodeId.getRawBytes());
            }
        }
    }

    @Override
    public void writePropertyId(PropertyId propertyId) throws JournalException {
        this.writeNodeId(propertyId.getParentId());
        this.writeQName(propertyId.getName());
    }

    @Override
    public void writeNodeTypeDef(QNodeTypeDefinition ntd) throws JournalException {
        try {
            StringWriter sw = new StringWriter();
            CompactNodeTypeDefWriter writer = new CompactNodeTypeDefWriter((Writer)sw, this.nsResolver, this.resolver);
            writer.write(ntd);
            writer.close();
            this.writeString(sw.toString());
        }
        catch (IOException e) {
            String msg = "I/O error while writing node type definition.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void writePrivilegeDef(PrivilegeDefinition privilegeDefinition) throws JournalException {
        try {
            HashMap<String, String> nsMapping = new HashMap<String, String>();
            String uri = privilegeDefinition.getName().getNamespaceURI();
            nsMapping.put(this.nsResolver.getPrefix(uri), uri);
            for (Name n : privilegeDefinition.getDeclaredAggregateNames()) {
                nsMapping.put(this.nsResolver.getPrefix(n.getNamespaceURI()), n.getNamespaceURI());
            }
            StringWriter sw = new StringWriter();
            PrivilegeDefinitionWriter writer = new PrivilegeDefinitionWriter("text/xml");
            writer.writeDefinitions((Writer)sw, new PrivilegeDefinition[]{privilegeDefinition}, nsMapping);
            sw.close();
            this.writeString(sw.toString());
        }
        catch (IOException e) {
            String msg = "I/O error while writing privilege definition.";
            throw new JournalException(msg, e);
        }
        catch (NamespaceException e) {
            String msg = "NamespaceException error while writing privilege definition.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public Name readQName() throws JournalException {
        try {
            return this.resolver.getQName(this.readString());
        }
        catch (NameException e) {
            String msg = "Unknown prefix error while reading name.";
            throw new JournalException(msg, e);
        }
        catch (NamespaceException e) {
            String msg = "Illegal name error while reading name.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public Path readPathElement() throws JournalException {
        try {
            Name name = this.resolver.getQName(this.readString());
            int index = this.readInt();
            if (index != 0) {
                return PathFactoryImpl.getInstance().create(name, index);
            }
            return PathFactoryImpl.getInstance().create(name);
        }
        catch (NameException e) {
            String msg = "Unknown prefix error while reading path element.";
            throw new JournalException(msg, e);
        }
        catch (NamespaceException e) {
            String msg = "Illegal name error while reading path element.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public Path readPath() throws JournalException {
        try {
            return this.resolver.getQPath(this.readString());
        }
        catch (MalformedPathException e) {
            String msg = "Malformed path error while reading path.";
            throw new JournalException(msg, e);
        }
        catch (NamespaceException e) {
            String msg = "Malformed path error while reading path.";
            throw new JournalException(msg, e);
        }
        catch (NameException e) {
            String msg = "Malformed path error while reading path.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public NodeId readNodeId() throws JournalException {
        byte uuidType = this.readByte();
        if (uuidType == 73) {
            int index = this.readInt();
            if (index == -1) {
                return null;
            }
            return (NodeId)this.nodeIdIndex.getKey((Object)index);
        }
        if (uuidType == 76) {
            byte[] b = new byte[16];
            this.readFully(b);
            NodeId nodeId = new NodeId(b);
            this.nodeIdIndex.put((Object)nodeId, (Object)this.nodeIdIndex.size());
            return nodeId;
        }
        String msg = "Unknown UUID type found: " + uuidType;
        throw new JournalException(msg);
    }

    @Override
    public PropertyId readPropertyId() throws JournalException {
        return new PropertyId(this.readNodeId(), this.readQName());
    }

    @Override
    public QNodeTypeDefinition readNodeTypeDef() throws JournalException {
        try {
            StringReader sr = new StringReader(this.readString());
            CompactNodeTypeDefReader reader = new CompactNodeTypeDefReader((Reader)sr, "(internal)", (Object)new NamespaceMapping(this.nsResolver), (DefinitionBuilderFactory)new QDefinitionBuilderFactory());
            List ntds = reader.getNodeTypeDefinitions();
            if (ntds.size() != 1) {
                throw new JournalException("Expected one node type definition: got " + ntds.size());
            }
            return (QNodeTypeDefinition)ntds.iterator().next();
        }
        catch (org.apache.jackrabbit.commons.cnd.ParseException e) {
            String msg = "Parse error while reading node type definition.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public PrivilegeDefinition readPrivilegeDef() throws JournalException {
        try {
            StringReader sr = new StringReader(this.readString());
            PrivilegeDefinitionReader reader = new PrivilegeDefinitionReader((Reader)sr, "text/xml");
            PrivilegeDefinition[] defs = reader.getPrivilegeDefinitions();
            if (defs.length != 1) {
                throw new JournalException("Expected one privilege definition: got " + defs.length);
            }
            return defs[0];
        }
        catch (ParseException e) {
            String msg = "Parse error while reading privilege definition.";
            throw new JournalException(msg, e);
        }
    }

    private int getOrCreateIndex(NodeId nodeId) {
        Integer index = (Integer)this.nodeIdIndex.get((Object)nodeId);
        if (index == null) {
            this.nodeIdIndex.put((Object)nodeId, (Object)this.nodeIdIndex.size());
            return -1;
        }
        return index;
    }
}

