/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.inspector.util;

import de.destatis.core.connect.util.ClientLogger;
import de.destatis.core.inspector.InspectionProblem;
import de.destatis.core.inspector.InspectionReport;
import de.destatis.core.inspector.ProblemPosition;
import de.destatis.core.inspector.util.DatmlRawResources;
import de.destatis.core.inspector.util.FatalException;
import de.destatis.core.inspector.util.InspectionReporter;
import de.destatis.core.inspector.util.InspectorConfig;
import de.destatis.core.inspector.util.XPathEntry;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Inspection
extends DefaultHandler {
    protected static ClientLogger LOG = ClientLogger.getLogger(Inspection.class);
    protected int inspectionLevel;
    private InspectorConfig config;
    private Stack elementPath = new Stack();
    private Stack layerElements = new Stack();
    private int elementDepth = 0;
    private InspectionReporter reporter;
    private int msgnum = 0;
    private int msgid = 0;
    private int declnum = 0;
    private int declid = 0;
    private int recnum = 0;
    private int recno = 0;
    private char[] textBuffer = new char[4096];
    private int bufferIndex = 0;
    private static final int maxChars = 4096;
    protected Locator locator;
    private boolean firstElementRead = false;

    public Inspection() {
        Arrays.fill(this.textBuffer, ' ');
    }

    public InspectionReport process(InspectorConfig config, InputSource document) throws IOException {
        this.config = config;
        this.reporter = new InspectionReporter();
        this.reporter.setLevel(this.inspectionLevel);
        this.reporter.setDate(new Date());
        this.reporter.setStatisticAndReportingPeriodSpecificInspection(this.config.getInspectionController() != null);
        try {
            this.parse(document);
        }
        catch (FatalException e) {
            LOG.error((Object)"Die Pr\u00fcfung konnte wegen eines nicht behebbaren Fehlers nicht fortgesetzt werden.");
        }
        return this.reporter.getReport();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.elementDepth = 0;
        this.msgnum = 0;
        this.msgid = 0;
        this.declnum = 0;
        this.declid = 0;
        this.recnum = 0;
        this.recno = 0;
        this.clearTextBuffer();
        this.layerElements.push(new HashMap());
        this.firstElementRead = false;
    }

    @Override
    public void startElement(String uri, String localName, String raw, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, raw, attributes);
        if (!this.firstElementRead) {
            if (this.locator != null) {
                String charset = null;
                Method getEncoding = null;
                try {
                    getEncoding = this.locator.getClass().getMethod("getEncoding", new Class[0]);
                    if (getEncoding != null) {
                        charset = (String)getEncoding.invoke((Object)this.locator, null);
                        this.getReporter().setCharset(charset);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.firstElementRead = true;
        }
        this.clearTextBuffer();
        ++this.elementDepth;
        XPathEntry entry = new XPathEntry(raw, attributes);
        this.elementPath.push(entry);
        Map occurenceMap = (Map)this.layerElements.peek();
        Integer occurences = (Integer)occurenceMap.get(entry.getOccurenceName());
        occurences = occurences == null ? new Integer(1) : new Integer(occurences + 1);
        occurenceMap.put(entry.getOccurenceName(), occurences);
        entry.setOccurrence(occurences);
        this.layerElements.push(new HashMap());
        if (DatmlRawResources.isMessage(raw)) {
            this.getReporter().nextMessage();
            ++this.msgnum;
            this.msgid = this.msgnum;
        } else if (DatmlRawResources.isDeclaration(raw)) {
            this.getReporter().nextDeclaration();
            ++this.declnum;
            this.declid = this.declnum;
        } else if (DatmlRawResources.isRecord(raw)) {
            ++this.recnum;
            this.recno = this.recnum;
        }
    }

    @Override
    public void endElement(String uri, String localName, String raw) throws SAXException {
        if (DatmlRawResources.isMessage(raw)) {
            this.declnum = 0;
        } else if (DatmlRawResources.isDeclaration(raw)) {
            this.declid = 0;
            this.recnum = 0;
        } else if (DatmlRawResources.isRecord(raw)) {
            this.recno = 0;
        }
        this.elementPath.pop();
        this.layerElements.pop();
        --this.elementDepth;
        super.endElement(uri, localName, raw);
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        block4: for (int i = start; i < start + length && this.bufferIndex < 4096; ++i) {
            switch (ch[i]) {
                case '\t': 
                case '\r': {
                    continue block4;
                }
                case '\n': {
                    this.textBuffer[this.bufferIndex++] = 32;
                    continue block4;
                }
                default: {
                    this.textBuffer[this.bufferIndex++] = ch[i];
                }
            }
        }
    }

    protected abstract void parse(InputSource var1) throws IOException;

    protected InspectorConfig getConfig() {
        return this.config;
    }

    protected InspectionReporter getReporter() {
        return this.reporter;
    }

    protected int getMessageID() {
        return this.msgid;
    }

    protected int getDeclarationID() {
        return this.declid;
    }

    protected int getRecordNo() {
        return this.recno;
    }

    protected int getCurrentXPathDepth() {
        return this.elementPath.size() - 1;
    }

    protected String getVariableName() {
        String varname = null;
        for (int idx = 0; idx < this.elementPath.size(); ++idx) {
            XPathEntry path = (XPathEntry)this.elementPath.get(idx);
            varname = path.getAttribute("name");
        }
        return varname;
    }

    protected int getCurrentElementOccurences() {
        int xPathDepth = this.getCurrentXPathDepth();
        XPathEntry path = (XPathEntry)this.elementPath.get(xPathDepth);
        int elementOccurences = path.getOccurrence();
        return elementOccurences;
    }

    protected int getCurrentLineNumber() {
        if (this.locator != null) {
            return this.locator.getLineNumber();
        }
        return -1;
    }

    protected int getCurrentColumnNumber() {
        if (this.locator != null) {
            return this.locator.getColumnNumber();
        }
        return -1;
    }

    protected String getCurrentXPath() {
        StringBuffer xpath = new StringBuffer();
        for (int xPathDepth = 0; xPathDepth < this.elementPath.size(); ++xPathDepth) {
            XPathEntry path = (XPathEntry)this.elementPath.get(xPathDepth);
            String entry = path.toString();
            xpath.append("/");
            xpath.append(entry);
        }
        return xpath.toString();
    }

    protected String getParentXPath() {
        int index;
        String xpath = this.getCurrentXPath();
        String parentXPath = xpath != null && xpath.length() > 0 ? ((index = xpath.lastIndexOf(47)) > 0 ? xpath.substring(0, index) : null) : null;
        return parentXPath;
    }

    protected ProblemPosition getCurrentPosition() {
        return new ProblemPosition(this.getCurrentLineNumber(), this.getCurrentColumnNumber(), this.getCurrentXPath(), this.getMessageID(), this.getDeclarationID(), this.getRecordNo(), this.getVariableName());
    }

    protected void infoProblem(int level, String num, String text) {
        this.infoProblem(level, null, num, text, null, this.getCurrentPosition());
    }

    protected void infoProblem(int level, String resid, String num, String text, String condition) {
        this.infoProblem(level, resid, num, text, condition, this.getCurrentPosition());
    }

    protected void infoProblem(int level, String num, String text, ProblemPosition pos) {
        this.infoProblem(level, null, num, text, null, pos);
    }

    protected void infoProblem(int level, String resid, String num, String text, String condition, ProblemPosition pos) {
        this.getReporter().addProblem(new InspectionProblem(level, resid, 1, level + "1" + num, text, condition, pos));
    }

    protected void warningProblem(int level, String num, String text) {
        this.warningProblem(level, null, num, text, null, this.getCurrentPosition());
    }

    protected void warningProblem(int level, String resid, String num, String text, String condition) {
        this.warningProblem(level, resid, num, text, condition, this.getCurrentPosition());
    }

    protected void warningProblem(int level, String num, String text, ProblemPosition pos) {
        this.warningProblem(level, null, num, text, null, pos);
    }

    protected void warningProblem(int level, String resid, String num, String text, String condition, ProblemPosition pos) {
        this.getReporter().addProblem(new InspectionProblem(level, resid, 2, level + "2" + num, text, condition, pos));
    }

    protected void errorProblem(int level, String num, String text) {
        this.errorProblem(level, null, num, text, null, this.getCurrentPosition());
    }

    protected void errorProblem(int level, String resid, String num, String text, String condition) {
        this.errorProblem(level, resid, num, text, condition, this.getCurrentPosition());
    }

    protected void errorProblem(int level, String num, String text, ProblemPosition pos) {
        this.errorProblem(level, null, num, text, null, pos);
    }

    protected void errorProblem(int level, String resid, String num, String text, String condition, ProblemPosition pos) {
        this.getReporter().addProblem(new InspectionProblem(level, resid, 3, level + "3" + num, text, condition, pos));
    }

    protected void fatalProblem(int level, String num, String text) {
        this.fatalProblem(level, null, num, text, null, this.getCurrentPosition());
    }

    protected void fatalProblem(int level, String resid, String num, String text, String condition) {
        this.fatalProblem(level, resid, num, text, condition, this.getCurrentPosition());
    }

    protected void fatalProblem(int level, String num, String text, ProblemPosition pos) {
        this.fatalProblem(level, null, num, text, null, pos);
    }

    protected void fatalProblem(int level, String resid, String num, String text, String condition, ProblemPosition pos) {
        this.getReporter().addProblem(new InspectionProblem(level, resid, 4, level + "4" + num, text, condition, pos));
    }

    protected String getTextBuffer() {
        String value = this.bufferIndex > 0 ? String.copyValueOf(this.textBuffer, 0, this.bufferIndex) : "";
        return value;
    }

    protected String getTextBufferTrimed() {
        String value = this.bufferIndex > 0 ? String.copyValueOf(this.textBuffer, 0, this.bufferIndex).trim() : "";
        return value;
    }

    private void clearTextBuffer() {
        this.bufferIndex = 0;
    }
}

