/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.types.lob;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

public class ImmutableBlob
implements Blob {
    private final byte[] bytes;

    public ImmutableBlob(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public long length() throws SQLException {
        return this.bytes.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        return Arrays.copyOfRange(this.bytes, (int)pos - 1, (int)(pos + (long)length));
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (start > 1L) {
            --start;
        }
        for (int i = (int)start; i < this.bytes.length - pattern.length; ++i) {
            if (this.bytes[i] != pattern[0] || !this.match(this.bytes, pattern, i)) continue;
            return i + 1;
        }
        return -1L;
    }

    boolean match(byte[] originalBytes, byte[] pattern, int index) {
        for (int i = index; i < pattern.length; ++i) {
            if (originalBytes[i] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException("setBytes");
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException("setBytes");
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException("setBinaryStream");
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException("truncate");
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return new ByteArrayInputStream(Arrays.copyOfRange(this.bytes, (int)pos, (int)length));
    }
}

