/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.HtmlSerializer;
import org.htmlcleaner.TagNode;

public class SimpleHtmlSerializer
extends HtmlSerializer {
    boolean escape = true;

    public SimpleHtmlSerializer(CleanerProperties props, boolean escape) {
        super(props);
        this.escape = escape;
    }

    public SimpleHtmlSerializer(CleanerProperties props) {
        super(props);
    }

    @Override
    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        this.serializeOpenTag(tagNode, writer, false);
        if (!this.isMinimizedTagSyntax(tagNode)) {
            for (BaseToken baseToken : tagNode.getAllChildren()) {
                if (baseToken instanceof ContentNode) {
                    String content = baseToken.toString();
                    writer.write(this.dontEscape(tagNode) || !this.escape ? content : this.escapeText(content));
                    continue;
                }
                if (!(baseToken instanceof BaseToken)) continue;
                baseToken.serialize(this, writer);
            }
            this.serializeEndTag(tagNode, writer, false);
        }
    }
}

