/*
 * Decompiled with CFR 0.152.
 */
package com.his.jackson.databind.node;

import com.his.jackson.core.JsonGenerator;
import com.his.jackson.core.JsonParser;
import com.his.jackson.core.JsonProcessingException;
import com.his.jackson.core.JsonToken;
import com.his.jackson.core.ObjectCodec;
import com.his.jackson.databind.JsonNode;
import com.his.jackson.databind.SerializerProvider;
import com.his.jackson.databind.jsontype.TypeSerializer;
import com.his.jackson.databind.node.InternalNodeMapper;
import com.his.jackson.databind.node.MissingNode;
import com.his.jackson.databind.node.NodeSerialization;
import com.his.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;
import java.io.Serializable;

public abstract class BaseJsonNode
extends JsonNode
implements Serializable {
    private static final long serialVersionUID = 1L;

    Object writeReplace() {
        return NodeSerialization.from(this);
    }

    protected BaseJsonNode() {
    }

    @Override
    public final JsonNode findPath(String fieldName) {
        JsonNode value = this.findValue(fieldName);
        if (value == null) {
            return MissingNode.getInstance();
        }
        return value;
    }

    public abstract int hashCode();

    @Override
    public JsonNode required(String fieldName) {
        return (JsonNode)this._reportRequiredViolation("Node of type `%s` has no fields", this.getClass().getSimpleName());
    }

    @Override
    public JsonNode required(int index) {
        return (JsonNode)this._reportRequiredViolation("Node of type `%s` has no indexed values", this.getClass().getSimpleName());
    }

    public JsonParser traverse() {
        return new TreeTraversingParser(this);
    }

    public JsonParser traverse(ObjectCodec codec) {
        return new TreeTraversingParser(this, codec);
    }

    public abstract JsonToken asToken();

    public JsonParser.NumberType numberType() {
        return null;
    }

    @Override
    public abstract void serialize(JsonGenerator var1, SerializerProvider var2) throws IOException, JsonProcessingException;

    @Override
    public abstract void serializeWithType(JsonGenerator var1, SerializerProvider var2, TypeSerializer var3) throws IOException, JsonProcessingException;

    @Override
    public String toString() {
        return InternalNodeMapper.nodeToString(this);
    }

    @Override
    public String toPrettyString() {
        return InternalNodeMapper.nodeToPrettyString(this);
    }
}

