/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.cff.CFFCharset;
import org.apache.fontbox.cff.IndexData;
import org.apache.fontbox.util.BoundingBox;

public abstract class CFFFont {
    protected String fontName;
    protected final Map<String, Object> topDict = new LinkedHashMap<String, Object>();
    protected CFFCharset charset;
    protected final List<byte[]> charStrings = new ArrayList<byte[]>();
    protected IndexData globalSubrIndex;

    public String getName() {
        return this.fontName;
    }

    void setName(String name) {
        this.fontName = name;
    }

    public void addValueToTopDict(String name, Object value) {
        if (value != null) {
            this.topDict.put(name, value);
        }
    }

    public Map<String, Object> getTopDict() {
        return this.topDict;
    }

    public abstract List<Number> getFontMatrix();

    public BoundingBox getFontBBox() {
        List numbers = (List)this.topDict.get("FontBBox");
        return new BoundingBox(numbers);
    }

    public CFFCharset getCharset() {
        return this.charset;
    }

    void setCharset(CFFCharset charset) {
        this.charset = charset;
    }

    List<byte[]> getCharStringBytes() {
        return this.charStrings;
    }

    public int getNumCharStrings() {
        return this.charStrings.size();
    }

    void setGlobalSubrIndex(IndexData globalSubrIndexValue) {
        this.globalSubrIndex = globalSubrIndexValue;
    }

    public IndexData getGlobalSubrIndex() {
        return this.globalSubrIndex;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.fontName + ", topDict=" + this.topDict + ", charset=" + this.charset + ", charStrings=" + this.charStrings + "]";
    }
}

