/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.webapp;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class WSDLRedirectFilter
implements Filter {
    public static final String WSDL_LOCATION_PARAM = "wsdl-location";
    private String wsdlLocation = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.wsdlLocation = filterConfig.getInitParameter(WSDL_LOCATION_PARAM);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (this.wsdlLocation != null && servletRequest.getParameterMap().containsKey("wsdl")) {
            HttpServletResponse res = (HttpServletResponse)servletResponse;
            res.sendRedirect(((HttpServletRequest)servletRequest).getContextPath() + this.wsdlLocation);
        } else {
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }
}

