/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.QName;
import org.codehaus.enunciate.qname.XmlQNameEnum;
import org.codehaus.enunciate.qname.XmlQNameEnumValue;
import org.codehaus.enunciate.qname.XmlUnknownQNameEnumValue;

public class XmlQNameEnumUtil {
    private static final AtomicReference<String> DEFAULT_BASE_URI = new AtomicReference();
    private static final AtomicBoolean WRITE_RELATIVE_URIS = new AtomicBoolean(false);

    private XmlQNameEnumUtil() {
    }

    public static void setDefaultBaseUri(String uri) {
        DEFAULT_BASE_URI.set(uri);
    }

    public static String getDefaultBaseUri() {
        return DEFAULT_BASE_URI.get();
    }

    public static boolean isWriteRelativeUris() {
        return WRITE_RELATIVE_URIS.get();
    }

    public static void setWriteRelativeUris(boolean writeRelativeUris) {
        WRITE_RELATIVE_URIS.set(writeRelativeUris);
    }

    public static <Q extends Enum<Q>> Q fromQName(QName qname, Class<Q> clazz) {
        Field[] fields;
        Package pkg;
        if (qname == null) {
            return null;
        }
        XmlQNameEnum enumInfo = clazz.getAnnotation(XmlQNameEnum.class);
        if (enumInfo == null) {
            throw new IllegalArgumentException(String.format("Class %s isn't a QName enum.", clazz.getName()));
        }
        if (enumInfo.base() != XmlQNameEnum.BaseType.QNAME) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is supposed to be converted from a URI (not QName).");
        }
        String namespace = enumInfo.namespace();
        if ("##default".equals(namespace) && (pkg = clazz.getPackage()) != null) {
            XmlSchema schemaInfo = pkg.getAnnotation(XmlSchema.class);
            namespace = schemaInfo.namespace();
        }
        Field unknown = null;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            if (field.getAnnotation(XmlUnknownQNameEnumValue.class) != null) {
                unknown = field;
                continue;
            }
            XmlQNameEnumValue enumValueInfo = field.getAnnotation(XmlQNameEnumValue.class);
            String ns = namespace;
            String localPart = field.getName();
            if (enumValueInfo != null) {
                if (enumValueInfo.exclude()) continue;
                if (!"##default".equals(enumValueInfo.namespace())) {
                    ns = enumValueInfo.namespace();
                }
                if (!"##default".equals(enumValueInfo.localPart())) {
                    localPart = enumValueInfo.localPart();
                }
            }
            if (!new QName(ns, localPart).equals(qname)) continue;
            return Enum.valueOf(clazz, field.getName());
        }
        if (unknown != null) {
            return Enum.valueOf(clazz, unknown.getName());
        }
        return null;
    }

    public static QName toQName(Enum e) {
        Field[] fields;
        Package pkg;
        if (e == null) {
            return null;
        }
        Class clazz = e.getDeclaringClass();
        XmlQNameEnum enumInfo = clazz.getAnnotation(XmlQNameEnum.class);
        if (enumInfo == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " isn't a QName enum.");
        }
        if (enumInfo.base() != XmlQNameEnum.BaseType.QNAME) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is supposed to be converted to a URI (not QName).");
        }
        String namespace = enumInfo.namespace();
        if ("##default".equals(namespace) && (pkg = clazz.getPackage()) != null) {
            XmlSchema schemaInfo = pkg.getAnnotation(XmlSchema.class);
            namespace = schemaInfo.namespace();
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isEnumConstant() || !field.getName().equals(e.name())) continue;
            if (field.getAnnotation(XmlUnknownQNameEnumValue.class) != null) {
                throw new IllegalArgumentException(e.getDeclaringClass().getName() + "." + e + " is not a QName enum value.");
            }
            XmlQNameEnumValue enumValueInfo = field.getAnnotation(XmlQNameEnumValue.class);
            String ns = namespace;
            String localPart = field.getName();
            if (enumValueInfo != null && !enumValueInfo.exclude()) {
                if (enumValueInfo.exclude()) {
                    throw new IllegalArgumentException(e.getDeclaringClass().getName() + "." + e + " is excluded a QName enum value.");
                }
                if (!"##default".equals(enumValueInfo.namespace())) {
                    ns = enumValueInfo.namespace();
                }
                if (!"##default".equals(enumValueInfo.localPart())) {
                    localPart = enumValueInfo.localPart();
                }
            }
            return new QName(ns, localPart);
        }
        throw new IllegalStateException("Unable to find " + e.getDeclaringClass().getName() + "." + e + " as a QName enum value.");
    }

    public static <Q extends Enum<Q>> Q fromURI(URI uri, Class<Q> clazz) {
        if (uri == null) {
            return null;
        }
        return XmlQNameEnumUtil.fromURIValue(uri.toString(), clazz);
    }

    public static <Q extends Enum<Q>> Q fromURIValue(String uriValue, Class<Q> clazz) {
        return XmlQNameEnumUtil.fromURIValue(uriValue, clazz, XmlQNameEnumUtil.getDefaultBaseUri());
    }

    public static <Q extends Enum<Q>> Q fromURIValue(String uriValue, Class<Q> clazz, String defaultBaseUri) {
        Field[] fields;
        Package pkg;
        XmlQNameEnum enumInfo;
        if (uriValue == null) {
            return null;
        }
        if (defaultBaseUri != null) {
            uriValue = URI.create(defaultBaseUri).resolve(uriValue).toString();
        }
        if ((enumInfo = clazz.getAnnotation(XmlQNameEnum.class)) == null) {
            throw new IllegalArgumentException(String.format("Class %s isn't a QName enum.", clazz.getName()));
        }
        if (enumInfo.base() != XmlQNameEnum.BaseType.URI) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is supposed to be converted to a QName (not URI).");
        }
        String namespace = enumInfo.namespace();
        if ("##default".equals(namespace) && (pkg = clazz.getPackage()) != null) {
            XmlSchema schemaInfo = pkg.getAnnotation(XmlSchema.class);
            namespace = schemaInfo.namespace();
        }
        Field unknown = null;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            if (field.getAnnotation(XmlUnknownQNameEnumValue.class) != null) {
                unknown = field;
                continue;
            }
            XmlQNameEnumValue enumValueInfo = field.getAnnotation(XmlQNameEnumValue.class);
            String ns = namespace;
            String localPart = field.getName();
            if (enumValueInfo != null) {
                if (enumValueInfo.exclude()) continue;
                if (!"##default".equals(enumValueInfo.namespace())) {
                    ns = enumValueInfo.namespace();
                }
                if (!"##default".equals(enumValueInfo.localPart())) {
                    localPart = enumValueInfo.localPart();
                }
            }
            if (!(ns + localPart).equals(uriValue)) continue;
            return Enum.valueOf(clazz, field.getName());
        }
        if (unknown != null) {
            return Enum.valueOf(clazz, unknown.getName());
        }
        return null;
    }

    public static URI toURI(Enum e) {
        if (e == null) {
            return null;
        }
        return URI.create(XmlQNameEnumUtil.toURIValue(e));
    }

    public static String toURIValue(Enum e) {
        return XmlQNameEnumUtil.toURIValue(e, XmlQNameEnumUtil.getDefaultBaseUri());
    }

    public static String toURIValue(Enum e, String defaultBaseUri) {
        Field[] fields;
        Package pkg;
        if (e == null) {
            return null;
        }
        String uriValue = null;
        Class clazz = e.getDeclaringClass();
        XmlQNameEnum enumInfo = clazz.getAnnotation(XmlQNameEnum.class);
        if (enumInfo == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " isn't a QName enum.");
        }
        if (enumInfo.base() != XmlQNameEnum.BaseType.URI) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is supposed to be converted from a QName (not URI).");
        }
        String namespace = enumInfo.namespace();
        if ("##default".equals(namespace) && (pkg = clazz.getPackage()) != null) {
            XmlSchema schemaInfo = pkg.getAnnotation(XmlSchema.class);
            namespace = schemaInfo.namespace();
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isEnumConstant() || !field.getName().equals(e.name())) continue;
            if (field.getAnnotation(XmlUnknownQNameEnumValue.class) != null) {
                throw new IllegalArgumentException(e.getDeclaringClass().getName() + "." + e + " is not a QName enum value.");
            }
            XmlQNameEnumValue enumValueInfo = field.getAnnotation(XmlQNameEnumValue.class);
            String ns = namespace;
            String localPart = field.getName();
            if (enumValueInfo != null && !enumValueInfo.exclude()) {
                if (enumValueInfo.exclude()) {
                    throw new IllegalArgumentException(e.getDeclaringClass().getName() + "." + e + " is excluded a QName enum value.");
                }
                if (!"##default".equals(enumValueInfo.namespace())) {
                    ns = enumValueInfo.namespace();
                }
                if (!"##default".equals(enumValueInfo.localPart())) {
                    localPart = enumValueInfo.localPart();
                }
            }
            if (ns.equals(defaultBaseUri) && XmlQNameEnumUtil.isWriteRelativeUris()) {
                ns = "";
            }
            uriValue = ns + localPart;
            break;
        }
        if (uriValue == null) {
            throw new IllegalStateException("Unable to find " + e.getDeclaringClass().getName() + "." + e + " as a QName enum value.");
        }
        return uriValue;
    }
}

