/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.Writer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.dbforms.taglib.TagSupportWithScriptHandler;

public class StyleTag
extends TagSupportWithScriptHandler
implements TryCatchFinally {
    private Hashtable params;
    private String paramList;
    private String part;
    private String template;
    private String templateBase;
    private String templateBaseDir;

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.templateBase = pageContext.getServletContext().getInitParameter("templateBase");
        if (this.templateBase == null) {
            this.templateBase = "templates";
        }
    }

    public void setParamList(String paramList) {
        this.paramList = paramList;
        this.params = this.parseParams(paramList);
    }

    public String getParamList() {
        return this.paramList;
    }

    public void setPart(String part) {
        this.part = part;
    }

    public String getPart() {
        return this.part;
    }

    public void setTemplate(String template) {
        this.template = template;
        this.templateBaseDir = this.templateBase + "/" + template + "/";
    }

    public String getTemplate() {
        return this.template;
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.bodyContent != null) {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
            }
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            if (this.params != null) {
                request.setAttribute("styleparams", (Object)this.params);
            }
            request.setAttribute("baseDir", (Object)this.templateBaseDir);
            this.pageContext.include(this.templateBaseDir + this.template + "_" + this.part + ".jsp");
        }
        catch (Exception ioe) {
            throw new JspException("Problem 2 including template end - " + ioe.toString());
        }
        return 6;
    }

    @Override
    public void doFinally() {
        this.params = null;
        this.templateBase = null;
        this.templateBaseDir = null;
        this.template = null;
        this.paramList = null;
        this.part = null;
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    private Hashtable parseParams(String s) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int equalSignIndex = token.indexOf(61);
            String key = token.substring(0, equalSignIndex).trim();
            String value = token.substring(equalSignIndex + 1).trim();
            if (value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
                value = value.substring(1, value.length() - 1);
            }
            result.put(key, value);
        }
        return result;
    }
}

