/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.IOException;
import java.util.List;
import org.dbforms.config.Field;
import org.dbforms.taglib.DataContainer;
import org.dbforms.taglib.DbSearchTag;
import org.dbforms.util.KeyValuePair;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.StringUtil;
import org.dbforms.util.Util;

public class DbSearchComboTag
extends DbSearchTag
implements DataContainer,
TryCatchFinally {
    private List embeddedData = null;
    private String compareWith = "key";
    private String customEntry;
    private String selectedIndex;
    private String size = "1";

    public DbSearchComboTag() {
        this.setSearchAlgo("sharp");
    }

    public void setCompareWith(String string) {
        this.compareWith = string;
    }

    public String getCompareWith() {
        return this.compareWith;
    }

    public void setCustomEntry(String customEntry) {
        this.customEntry = customEntry;
    }

    public String getCustomEntry() {
        return this.customEntry;
    }

    @Override
    public void setEmbeddedData(List embeddedData) {
        this.embeddedData = embeddedData;
    }

    public void setSelectedIndex(String selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public String getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSize(String string) {
        this.size = string;
    }

    public String getSize() {
        return this.size;
    }

    @Override
    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Field field = this.getField();
        StringBuffer tagBuf = new StringBuffer();
        String oldValue = ParseUtil.getParameter(request, field.getSearchFieldName());
        if (!Util.isNull(oldValue)) {
            this.selectedIndex = oldValue;
        }
        boolean isSelected = false;
        if (this.embeddedData != null) {
            if (!Util.isNull(this.customEntry)) {
                String aKey = StringUtil.getEmbeddedStringWithoutDots(this.customEntry, 0, ',');
                String aValue = StringUtil.getEmbeddedStringWithoutDots(this.customEntry, 1, ',');
                if (Util.isNull(this.selectedIndex)) {
                    isSelected = Util.getTrue(StringUtil.getEmbeddedStringWithoutDots(this.customEntry, 2, ',').trim());
                }
                tagBuf.append(this.generateTagString(aKey, aValue, isSelected));
            }
            int embeddedDataSize = this.embeddedData.size();
            int selectedIndexList = 0;
            try {
                selectedIndexList = Integer.parseInt(this.selectedIndex);
            }
            catch (Exception e) {
                selectedIndexList = 0;
            }
            for (int i = 0; i < embeddedDataSize; ++i) {
                KeyValuePair aKeyValuePair = (KeyValuePair)this.embeddedData.get(i);
                String aKey = aKeyValuePair.getKey();
                String aValue = aKeyValuePair.getValue();
                isSelected = Util.isNull(this.selectedIndex) && !isSelected ? i == 0 : ("value".equalsIgnoreCase(this.getCompareWith()) ? aValue.equals(this.selectedIndex) : ("list".equalsIgnoreCase(this.getCompareWith()) ? selectedIndexList == i : aKey.equals(this.selectedIndex)));
                tagBuf.append(this.generateTagString(aKey, aValue, isSelected));
            }
        }
        tagBuf.append("</select>");
        try {
            this.pageContext.getOut().write(this.renderPatternHtmlInputField());
            this.pageContext.getOut().write(this.RenderHiddenFields(field));
            this.pageContext.getOut().write(this.generateSelectHeader(field));
            this.pageContext.getOut().write(tagBuf.toString());
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
        return 6;
    }

    @Override
    public void doFinally() {
        this.embeddedData = null;
        this.selectedIndex = null;
        this.customEntry = null;
        this.size = "1";
        this.compareWith = "key";
        super.doFinally();
    }

    public int doStartTag() throws JspException {
        return 1;
    }

    private String generateSelectHeader(Field f) throws JspException {
        StringBuffer tagBuf = new StringBuffer();
        tagBuf.append("<select name=\"");
        tagBuf.append(f.getSearchFieldName());
        tagBuf.append("\"");
        if (this.size != null) {
            tagBuf.append(" size=\"");
            tagBuf.append(this.size);
            tagBuf.append("\"");
        }
        tagBuf.append(this.prepareStyles());
        tagBuf.append(this.prepareEventHandlers());
        tagBuf.append(">");
        return tagBuf.toString();
    }

    private String generateTagString(String value, String description, boolean selected) {
        StringBuffer tagBuf = new StringBuffer();
        tagBuf.append("<option value=\"");
        tagBuf.append(value);
        tagBuf.append("\"");
        if (selected) {
            tagBuf.append(" selected=\"selected\"");
        }
        tagBuf.append(">");
        tagBuf.append(description.trim());
        tagBuf.append("</option>");
        return tagBuf.toString();
    }
}

