/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.Table;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.util.Util;

public class DbLinkURLTag
extends DbBaseHandlerTag
implements TryCatchFinally {
    private static Log logCat = LogFactory.getLog((String)DbLinkURLTag.class.getName());
    private transient FieldValues positionFv;
    private String childField;
    private String href;
    private String keyToDestPos;
    private String keyToKeyToDestPos;
    private String parentField;
    private String position;
    private String singleRow = "false";
    private String tableName;

    public void setChildField(String childField) {
        this.childField = childField;
    }

    public String getChildField() {
        return this.childField;
    }

    public void setDestPos(String position) {
        this.position = position;
    }

    public String getDestPos() {
        return this.position;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getHref() {
        return this.href;
    }

    public void setKeyToDestPos(String keyToDestPos) {
        this.keyToDestPos = keyToDestPos;
    }

    public String getKeyToDestPos() {
        return this.keyToDestPos;
    }

    public void setKeyToKeyToDestPos(String keyToKeyToDestPos) {
        this.keyToKeyToDestPos = keyToKeyToDestPos;
    }

    public String getKeyToKeyToDestPos() {
        return this.keyToKeyToDestPos;
    }

    public void setParentField(String parentField) {
        this.parentField = parentField;
    }

    public String getParentField() {
        return this.parentField;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getPosition() {
        return this.position;
    }

    public void setSingleRow(String string) {
        this.singleRow = string;
    }

    public String getSingleRow() {
        return this.singleRow;
    }

    public Table getTable() {
        if (!Util.isNull(this.tableName)) {
            return this.getConfig().getTableByName(this.tableName);
        }
        if (this.getParentForm() != null) {
            return this.getParentForm().getTable();
        }
        throw new IllegalArgumentException("no table specified. either you define expliclty the attribute \"tableName\" or you put this tag inside a db:form!");
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void addPositionPart(Field field, String value) {
        if (this.positionFv == null) {
            this.positionFv = new FieldValues();
        }
        FieldValue fv = new FieldValue(field, value);
        this.positionFv.put(fv);
    }

    public int doBodyEndTag() throws JspException {
        return 0;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public int doEndTag() throws JspException {
        try {
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            String s = this.makeUrl();
            s = response.encodeURL(s);
            this.pageContext.getOut().write(s);
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
        catch (Exception e) {
            throw new JspException("Error: " + e.getMessage());
        }
        return 6;
    }

    @Override
    public void doFinally() {
        logCat.info((Object)"doFinally called");
        this.position = null;
        if (this.positionFv != null) {
            this.positionFv.clear();
        }
        this.positionFv = null;
        this.href = null;
        this.tableName = null;
        this.position = null;
        this.keyToDestPos = null;
        this.keyToKeyToDestPos = null;
        this.singleRow = "false";
        super.doFinally();
    }

    public int doStartTag() throws JspException {
        if (Util.isNull(this.getPosition())) {
            return 2;
        }
        return 0;
    }

    protected String makeUrl() throws UnsupportedEncodingException {
        if (this.position == null && this.positionFv != null) {
            this.position = this.getTable().getKeyPositionString(this.positionFv);
        }
        StringBuffer tagBuf = new StringBuffer(200);
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String contextPath = request.getContextPath();
        tagBuf.append(contextPath);
        if (!contextPath.endsWith("/")) {
            tagBuf.append("/");
        }
        tagBuf.append("servlet/control?");
        String tagName = "ac_goto";
        tagBuf.append(this.getDataTag(tagName, "x", "t"));
        tagName = "data" + tagName + "_x";
        tagBuf.append(this.getDataTag(tagName, "fu", this.href));
        tagBuf.append(this.getDataTag(tagName, "destTable", this.getTable().getName()));
        tagBuf.append(this.getDataTag(tagName, "destPos", Util.encode(this.position, this.pageContext.getRequest().getCharacterEncoding())));
        tagBuf.append(this.getDataTag(tagName, "keyToDestPos", Util.encode(this.keyToDestPos, this.pageContext.getRequest().getCharacterEncoding())));
        tagBuf.append(this.getDataTag(tagName, "keyToKeyDestPos", Util.encode(this.keyToKeyToDestPos, this.pageContext.getRequest().getCharacterEncoding())));
        if (this.getTable() != this.getParentForm().getTable()) {
            tagBuf.append(this.getDataTag(tagName, "srcTable", this.getParentForm().getTable().getName()));
            tagBuf.append(this.getDataTag(tagName, "childField", Util.encode(this.childField, this.pageContext.getRequest().getCharacterEncoding())));
            tagBuf.append(this.getDataTag(tagName, "parentField", Util.encode(this.parentField, this.pageContext.getRequest().getCharacterEncoding())));
        }
        tagBuf.append(this.getDataTag(tagName, "singleRow", this.getSingleRow()));
        String s = tagBuf.toString();
        s = s.substring(0, s.length() - 1);
        return s;
    }

    private String getDataTag(String primaryTagName, String dataKey, String dataValue) {
        String s = "";
        if (!Util.isNull(dataValue)) {
            StringBuffer tagBuf = new StringBuffer();
            tagBuf.append(primaryTagName);
            tagBuf.append("_");
            tagBuf.append(dataKey);
            tagBuf.append("=");
            tagBuf.append(dataValue);
            tagBuf.append("&");
            s = tagBuf.toString();
        }
        return s;
    }
}

