/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.Tag;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.Table;
import org.dbforms.taglib.DataContainer;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.taglib.DbFilterConditionTag;
import org.dbforms.util.KeyValuePair;
import org.dbforms.util.MessageResources;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.StringUtil;
import org.dbforms.util.Util;

public class DbFilterValueTag
extends DbBaseHandlerTag
implements DataContainer,
TryCatchFinally {
    private static String FLT_VALUETYPE_DATE = "date";
    private static String FLT_VALUETYPE_NUMERIC = "numeric";
    private static String FLT_VALUETYPE_SELECT = "select";
    private static String FLT_VALUETYPE_TEXT = "text";
    private static String FLT_VALUETYPE_TIMESTAMP = "timestamp";
    private static Log logCat = LogFactory.getLog((String)DbFilterValueTag.class.getName());
    private transient State state = new State();

    public void setCustomEntry(String string) {
        this.state.customEntry = string;
    }

    @Override
    public void setEmbeddedData(List embeddedData) {
        this.state.embeddedData = embeddedData;
    }

    public void setJsCalendarDateFormat(String string) {
        this.state.jsCalendarDateFormat = string;
    }

    public String getJsCalendarDateFormat() {
        return this.state.jsCalendarDateFormat;
    }

    public void setLabel(String string) {
        this.state.label = string;
    }

    public String getLabel() {
        return this.state.label;
    }

    public void setSearchAlgo(String value) {
        this.state.searchAlgo = value;
    }

    public String getSearchAlgo() {
        return this.state.searchAlgo;
    }

    public void setSelectedIndex(String string) {
        this.state.selectedIndex = string;
    }

    public void setSize(String string) {
        this.state.size = string;
    }

    public void setState(PageContext pg, DbFilterConditionTag parent, State state) {
        this.setPageContext(pg);
        this.setParent((Tag)parent);
        this.state = state;
    }

    @Override
    public void setStyleClass(String string) {
        this.state.styleClass = string;
    }

    public void setType(String string) {
        this.state.type = string;
    }

    public void setUseJsCalendar(String string) {
        this.state.useJsCalendar = string;
    }

    public String getUseJsCalendar() {
        return this.state.useJsCalendar;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public void doFinally() {
        this.state = new State();
        super.doFinally();
    }

    public int doStartTag() throws JspException {
        this.init();
        return 2;
    }

    protected static FieldValue[] readValuesFromRequest(HttpServletRequest request, int tableId, int conditionId) {
        FieldValues values = new FieldValues();
        int valueId = 0;
        while (true) {
            String paramValue = DbFilterConditionTag.getConditionName(tableId, conditionId) + "_value_" + valueId;
            String paramType = DbFilterConditionTag.getConditionName(tableId, conditionId) + "_valuetype_" + valueId;
            String searchAlgoType = DbFilterConditionTag.getConditionName(tableId, conditionId) + "_searchalgo_" + valueId;
            String value = ParseUtil.getParameter(request, paramValue);
            String valueType = ParseUtil.getParameter(request, paramType);
            String aSearchAlgorithm = ParseUtil.getParameter(request, searchAlgoType);
            int algorithm = 0;
            if (!Util.isNull(aSearchAlgorithm)) {
                if (aSearchAlgorithm.startsWith("weakStartEnd")) {
                    algorithm = 4;
                } else if (aSearchAlgorithm.startsWith("weakStart")) {
                    algorithm = 2;
                } else if (aSearchAlgorithm.startsWith("weakEnd")) {
                    algorithm = 3;
                } else if (aSearchAlgorithm.startsWith("weak")) {
                    algorithm = 1;
                }
            }
            String string = valueType = Util.isNull(valueType) ? FLT_VALUETYPE_TEXT : valueType;
            if (value == null) break;
            Field f = new Field();
            f.setName(paramValue);
            f.setId(valueId);
            f.setFieldType(valueType);
            Table table = null;
            try {
                table = DbFormsConfigRegistry.instance().lookup().getTable(tableId);
            }
            catch (Exception e) {
                logCat.error((Object)"readValuesFromRequest", (Throwable)e);
            }
            f.setTable(table);
            FieldValue fv = new FieldValue(f, value);
            fv.setLocale(MessageResources.getLocale(request));
            fv.setSearchAlgorithm(algorithm);
            values.put(fv);
            ++valueId;
        }
        return values.toArray();
    }

    @Override
    protected Object getFieldObject() {
        FieldValue fv = new FieldValue(this.getField(), this.state.value);
        fv.setLocale(MessageResources.getLocale((HttpServletRequest)this.pageContext.getRequest()));
        return fv.getFieldValueAsObject();
    }

    protected State getState() {
        return this.state;
    }

    protected StringBuffer render() throws JspException {
        StringBuffer buf = new StringBuffer();
        Field f = new Field();
        f.setName(this.state.label);
        f.setId(this.state.valueId);
        f.setFieldType(this.state.type);
        f.setTable(this.getParentForm().getTable());
        this.setField(f);
        if (this.state.label != null) {
            buf.append("<b>" + this.state.label + "</b>\n");
        }
        if (this.state.type.equalsIgnoreCase(FLT_VALUETYPE_TEXT) || this.state.type.equalsIgnoreCase(FLT_VALUETYPE_NUMERIC)) {
            this.renderTextElement(buf);
        } else if (this.state.type.equalsIgnoreCase(FLT_VALUETYPE_DATE) || this.state.type.equalsIgnoreCase(FLT_VALUETYPE_TIMESTAMP)) {
            this.renderDateElement(buf);
        } else if (FLT_VALUETYPE_SELECT.equalsIgnoreCase(this.state.type) && this.state.embeddedData != null) {
            this.renderSelectElement(buf);
        } else {
            throw new JspException("type not correct");
        }
        return buf;
    }

    private String getSearchAlgoType() {
        return ((DbFilterConditionTag)this.getParent()).getConditionName() + "_searchalgo_" + this.state.valueId;
    }

    private String getValueName() {
        return ((DbFilterConditionTag)this.getParent()).getConditionName() + "_value_" + this.state.valueId;
    }

    private String getValueType() {
        return ((DbFilterConditionTag)this.getParent()).getConditionName() + "_valuetype_" + this.state.valueId;
    }

    private String generateTagString(String value, String description, boolean selected) {
        StringBuffer tagBuf = new StringBuffer();
        tagBuf.append("<option value=\"");
        tagBuf.append(value);
        tagBuf.append("\"");
        if (selected) {
            tagBuf.append(" selected=\"selected\"");
        }
        tagBuf.append(">");
        tagBuf.append(description.trim());
        tagBuf.append("</option>");
        return tagBuf.toString();
    }

    private void init() {
        if (this.state.type == null) {
            this.state.type = "text";
        }
        if (this.state.styleClass == null) {
            this.state.styleClass = "";
        }
        this.state.valueId = ((DbFilterConditionTag)this.getParent()).addValue(this);
        this.state.value = ParseUtil.getParameter((HttpServletRequest)this.pageContext.getRequest(), this.getValueName());
        if (this.state.value == null) {
            this.state.value = "";
        }
        this.state.embeddedData = null;
    }

    private void renderDateElement(StringBuffer buf) {
        this.renderTextElement(buf);
        if ("true".equals(this.state.useJsCalendar)) {
            buf.append(" <a href=\"javascript:doNothing()\" ").append(" onclick=\"");
            this.setPattern(this.state.jsCalendarDateFormat);
            this.state.jsCalendarDateFormat = ((SimpleDateFormat)this.getFormatter()).toPattern();
            if (this.state.jsCalendarDateFormat != null) {
                buf.append("calDateFormat='" + this.state.jsCalendarDateFormat + "';");
            }
            buf.append("setDateField(document.dbform['").append(this.getValueName()).append("']);").append(" top.newWin = window.open('").append(((HttpServletRequest)this.pageContext.getRequest()).getContextPath()).append("/jscal/calendar.html','cal','width=270,height=280')\">").append("<img src=\"").append(((HttpServletRequest)this.pageContext.getRequest()).getContextPath()).append("/jscal/calendar.gif\" width=\"32\" height=\"32\" ").append(" border=0  alt=\"Click on the Calendar to activate the Pop-Up Calendar Window.\">").append("</img>").append("</a>");
        }
    }

    private void renderSelectElement(StringBuffer buf) {
        String sizestr = "";
        if (this.state.size != null) {
            sizestr = "size=\"" + this.state.size + "\" ";
        }
        buf.append("<select name=\"" + this.getValueName() + "\" " + sizestr + " class=\"" + this.state.styleClass + "\">\n");
        if (this.state.customEntry != null && this.state.customEntry.trim().length() > 0) {
            String aKey = StringUtil.getEmbeddedStringWithoutDots(this.state.customEntry, 0, ',');
            String aValue = StringUtil.getEmbeddedStringWithoutDots(this.state.customEntry, 1, ',');
            boolean isSelected = false;
            if (this.state.selectedIndex == null || this.state.selectedIndex.trim().length() == 0) {
                isSelected = "true".equals(StringUtil.getEmbeddedStringWithoutDots(this.state.customEntry, 2, ','));
            }
            buf.append(this.generateTagString(aKey, aValue, isSelected));
        }
        int embeddedDataSize = this.state.embeddedData.size();
        for (int i = 0; i < embeddedDataSize; ++i) {
            KeyValuePair aKeyValuePair = (KeyValuePair)this.state.embeddedData.get(i);
            String aKey = aKeyValuePair.getKey();
            String aValue = aKeyValuePair.getValue();
            boolean isSelected = aKey.equals(this.state.value);
            buf.append(this.generateTagString(aKey, aValue, isSelected));
        }
        buf.append("</select>\n");
    }

    private void renderTextElement(StringBuffer buf) {
        String sizestr = "";
        if (this.state.size != null) {
            sizestr = "size=\"" + this.state.size + "\" ";
        }
        buf.append("<input type=\"text\" name=\"" + this.getValueName() + "\" value=\"" + this.getFormattedFieldValue() + "\"" + sizestr + " class=\"" + this.state.styleClass + "\"/>\n");
        buf.append("<input type=\"hidden\" name=\"" + this.getValueType() + "\" value=\"" + this.state.type.toLowerCase() + "\"/>\n");
        if (!Util.isNull(this.state.searchAlgo)) {
            buf.append("<input type=\"hidden\" name=\"" + this.getSearchAlgoType() + "\" value=\"" + this.state.searchAlgo + "\"/>\n");
        }
    }

    protected static class State {
        protected List embeddedData = null;
        protected String customEntry = null;
        protected String jsCalendarDateFormat = null;
        protected String label = null;
        protected String searchAlgo = null;
        protected String selectedIndex = null;
        protected String size = null;
        protected String styleClass = null;
        protected String type = null;
        protected String useJsCalendar = null;
        protected String value = null;
        protected int valueId = -1;

        protected State() {
        }
    }
}

