/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.datalist;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.FieldValue;
import org.dbforms.config.ResultSetVector;
import org.dbforms.config.Table;
import org.dbforms.event.NavigationEvent;
import org.dbforms.event.datalist.dao.DataSourceFactory;
import org.dbforms.event.datalist.dao.DataSourceSessionList;

public class ReloadEvent
extends NavigationEvent {
    private static Log logCat = LogFactory.getLog((String)ReloadEvent.class.getName());
    private boolean isForce = false;
    private boolean isInsert = false;

    public ReloadEvent(String action, HttpServletRequest request, DbFormsConfig config) {
        super(action, request, config);
        this.isForce = action.indexOf("_force_") > 0;
        this.isInsert = !this.isForce && action.indexOf("_ins_") > 0;
    }

    public ReloadEvent(Table table, HttpServletRequest request, DbFormsConfig config) {
        super(table, request, config);
    }

    @Override
    public ResultSetVector processEvent(FieldValue[] filterFieldValues, FieldValue[] orderConstraint, String sqlFilter, FieldValue[] sqlFilterParams, int count, String firstPosition, String lastPosition, DbEventInterceptorData interceptorData) throws SQLException {
        ResultSetVector res;
        if (this.isInsert) {
            return null;
        }
        logCat.info((Object)"==>NavCurrentEvent.processEvent");
        DataSourceSessionList ds = DataSourceSessionList.getInstance(this.getRequest());
        DataSourceFactory qry = null;
        String position = null;
        if (this.isForce) {
            this.setType("navForceReload");
            ds.remove(this.getTable(), this.getRequest());
        } else {
            qry = ds.get(this.getTable(), this.getRequest());
        }
        if (qry == null) {
            qry = new DataSourceFactory((String)interceptorData.getAttribute("connectionName"), interceptorData.getConnection(), this.getTable());
            qry.setSelect(filterFieldValues, orderConstraint, sqlFilter, sqlFilterParams);
            ds.put(this.getTable(), this.getRequest(), qry);
        }
        if (ResultSetVector.isNull(res = qry.getCurrent(interceptorData, position = count == 0 ? null : this.getTable().getKeyPositionString(this.getTable().getFieldValues(lastPosition)), count))) {
            res = qry.getLast(interceptorData, count);
        }
        return res;
    }
}

