/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.classic;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.JDBCDataHelper;
import org.dbforms.config.ResultSetVector;
import org.dbforms.event.ValidationEvent;
import org.dbforms.util.FileHolder;
import org.dbforms.util.MessageResourcesInternal;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.StringUtil;
import org.dbforms.util.UniqueIDGenerator;
import org.dbforms.util.Util;

public class InsertEvent
extends ValidationEvent {
    static Log logCat = LogFactory.getLog((String)InsertEvent.class.getName());

    public InsertEvent(Integer tableId, String keyId, HttpServletRequest request, DbFormsConfig config) {
        super(tableId, keyId, request, config);
    }

    public InsertEvent(String action, HttpServletRequest request, DbFormsConfig config) {
        super(StringUtil.getEmbeddedStringAsInteger(action, 2, '_'), StringUtil.getEmbeddedString(action, 3, '_'), request, config);
    }

    @Override
    public FieldValues getFieldValues() {
        return this.getFieldValues(true);
    }

    @Override
    public void processEvent(Connection con) throws SQLException {
        if (!this.hasUserPrivileg(1)) {
            String s = MessageResourcesInternal.getMessage("dbforms.events.insert.nogrant", this.getRequest().getLocale(), new String[]{this.getTable().getName()});
            throw new SQLException(s);
        }
        FieldValues fieldValues = this.getFieldValues();
        if (fieldValues.size() == 0) {
            throw new SQLException("no parameters");
        }
        DbEventInterceptorData interceptorData = new DbEventInterceptorData(this.getRequest(), this.getConfig(), con, this.getTable());
        interceptorData.setAttribute("fieldValues", fieldValues);
        int operation = this.getTable().processInterceptors(0, interceptorData);
        if (operation == 0 && fieldValues.size() > 0) {
            int fieldType;
            Field curField;
            if (!this.checkSufficentValues(fieldValues)) {
                throw new SQLException("unsufficent parameters");
            }
            PreparedStatement ps = con.prepareStatement(this.getTable().getInsertStatement(fieldValues));
            Iterator iter = fieldValues.elements();
            int col = 1;
            while (iter.hasNext()) {
                FieldValue fv = (FieldValue)iter.next();
                if (fv == null) continue;
                curField = fv.getField();
                logCat.debug((Object)("Retrieved curField:" + curField.getName() + " type:" + curField.getType()));
                fieldType = curField.getType();
                Object value = null;
                if (fieldType == 2004) {
                    value = fv.getFileHolder();
                } else if (fieldType == 4200) {
                    FileHolder fileHolder = fv.getFileHolder();
                    String fileName = fileHolder.getFileName();
                    if (curField.hasEncodedSet()) {
                        int dotIndex = fileName.lastIndexOf(46);
                        String suffix = dotIndex != -1 ? fileName.substring(dotIndex) : "";
                        fileHolder.setFileName(UniqueIDGenerator.getUniqueID() + suffix);
                        value = fileHolder.getFileName();
                    } else {
                        value = fileName;
                    }
                } else {
                    value = fv.getFieldValueAsObject();
                }
                logCat.info((Object)("PRE_INSERT: field=" + curField.getName() + " col=" + col + " value=" + value + " type=" + fieldType));
                JDBCDataHelper.fillWithData(ps, fv.getField().getEscaper(), col, value, fieldType, this.getTable().getBlobHandlingStrategy());
                ++col;
            }
            ps.executeUpdate();
            ps.close();
            iter = fieldValues.keys();
            while (iter.hasNext()) {
                String fieldName = (String)iter.next();
                curField = this.getTable().getFieldByName(fieldName);
                if (curField == null) continue;
                fieldType = curField.getType();
                String directory = null;
                try {
                    directory = Util.replaceRealPath(curField.getDirectory(), DbFormsConfigRegistry.instance().lookup().getRealPath());
                }
                catch (Exception e) {
                    throw new SQLException(e.getMessage());
                }
                if (fieldType != 4200) continue;
                if (directory == null) {
                    throw new IllegalArgumentException("directory-attribute needed for fields of type DISKBLOB");
                }
                File dir = new File(directory);
                if (!dir.isDirectory()) {
                    throw new IllegalArgumentException("Not a directory: " + directory);
                }
                if (!dir.canWrite()) {
                    throw new IllegalArgumentException("Not writable: " + directory);
                }
                FileHolder fileHolder = ParseUtil.getFileHolder(this.getRequest(), "f_" + this.getTable().getId() + "_ins" + this.getKeyId() + "_" + curField.getId());
                if (fileHolder != null) {
                    try {
                        fileHolder.writeBufferToFile(dir);
                        logCat.info((Object)"fin + closedy");
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new SQLException("could not store file '" + fileHolder.getFileName() + "' to dir '" + directory + "'");
                    }
                }
                logCat.info((Object)"uh! empty fileHolder");
            }
            String firstPosition = null;
            Vector key = this.getTable().getKey();
            FieldValue[] fvEqual = new FieldValue[key.size()];
            for (int i = 0; i < key.size(); ++i) {
                FieldValue keyFieldValue;
                Field field = (Field)key.elementAt(i);
                String fieldName = field.getName();
                FieldValue fv = fieldValues.get(fieldName);
                String value = null;
                if (fv != null) {
                    value = fv.getFieldValue();
                }
                fvEqual[i] = keyFieldValue = new FieldValue(field, value);
            }
            ResultSetVector resultSetVector = this.getTable().doConstrainedSelect(fvEqual, null, null, null, 0, 1, interceptorData);
            if (resultSetVector != null) {
                resultSetVector.moveFirst();
                firstPosition = this.getTable().getPositionString(resultSetVector);
            }
            this.getRequest().setAttribute("firstpos_" + this.getTable().getId(), (Object)firstPosition);
            this.getTable().processInterceptors(1, interceptorData);
        }
    }

    private boolean checkSufficentValues(FieldValues fieldValues) throws SQLException {
        Vector fields = this.getTable().getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.elementAt(i);
            if (!field.hasAutoIncSet() && field.hasIsKeySet()) {
                if (fieldValues.get(field.getName()) != null) continue;
                throw new SQLException("Field " + field.getName() + " is missing");
            }
            if (!field.hasAutoIncSet() || fieldValues.get(field.getName()) == null) continue;
            throw new SQLException("Field " + field.getName() + " should be calculated by RDBMS, remove it from the form");
        }
        return true;
    }
}

