/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.EventInfo;
import org.dbforms.config.Table;
import org.dbforms.event.NavEventFactory;
import org.dbforms.event.NavigationEvent;
import org.dbforms.event.WebEvent;

public class NavEventFactoryImpl
extends NavEventFactory {
    private static NavEventFactory instance = null;
    private static Log logCat = LogFactory.getLog(NavEventFactoryImpl.class);

    public static synchronized NavEventFactory instance() {
        if (instance == null) {
            instance = new NavEventFactoryImpl();
        }
        return instance;
    }

    @Override
    public WebEvent createEvent(String action, HttpServletRequest request, DbFormsConfig config) {
        Object[] constructorArgs = new Object[]{action, request, config};
        String eventId = this.getEventIdFromDestinationTable(request, action);
        EventInfo einfo = this.getEventInfo(eventId);
        logCat.info((Object)("::createEvent - got event [" + einfo + "] from action [" + action + "]"));
        return this.getEvent(einfo, constructorArgsTypes, constructorArgs);
    }

    @Override
    public NavigationEvent createEvent(String action, HttpServletRequest request, DbFormsConfig config, Table table) {
        Object[] constructorArgs = new Object[]{table, request, config};
        String eventId = this.getEventIdFromDestinationTable(table, action);
        EventInfo einfo = this.getEventInfo(eventId);
        logCat.info((Object)("::createEvent - got event [" + einfo + "] from action [" + action + "]"));
        return (NavigationEvent)this.getEvent(einfo, actionConstructorArgsTypes, constructorArgs);
    }

    @Override
    public NavigationEvent createGotoEvent(Table table, HttpServletRequest request, DbFormsConfig config, String positionString) {
        String eventId = table.getTableEvents().getEventId("navGoto");
        EventInfo einfo = this.getEventInfo(eventId);
        Object[] constructorArgs = new Object[]{table, request, config, positionString};
        return (NavigationEvent)this.getEvent(einfo, goToConstructorArgsTypes, constructorArgs);
    }

    @Override
    public NavigationEvent createGotoEvent(Table table, HttpServletRequest request, DbFormsConfig config, String whereClause, String tableList) {
        String eventId = table.getTableEvents().getEventId("navGoto");
        EventInfo einfo = this.getEventInfo(eventId);
        Object[] constructorArgs = new Object[]{table, request, config, whereClause, tableList};
        return (NavigationEvent)this.getEvent(einfo, goToConstructorArgsTypes2, constructorArgs);
    }

    @Override
    protected void initializeEvents() throws Exception {
        this.addEventInfo(new EventInfo("navNew", "org.dbforms.event.NavNewEvent"));
        this.addEventInfo(new EventInfo("navCopy", "org.dbforms.event.NavCopyEvent"));
        this.addEventInfo(new EventInfo("navGoto", "org.dbforms.event.datalist.GotoEvent"));
        this.addEventInfo(new EventInfo("navFirst", "org.dbforms.event.datalist.NavFirstEvent"));
        this.addEventInfo(new EventInfo("navLast", "org.dbforms.event.datalist.NavLastEvent"));
        this.addEventInfo(new EventInfo("navNext", "org.dbforms.event.datalist.NavNextEvent"));
        this.addEventInfo(new EventInfo("navPrev", "org.dbforms.event.datalist.NavPrevEvent"));
        this.addEventInfo(new EventInfo("navReload", "org.dbforms.event.datalist.ReloadEvent"));
    }
}

