/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.dom;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.dom.DOMFactoryXALANImpl;
import org.dbforms.util.ReflectionUtil;
import org.dbforms.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.xpath.XPathEvaluator;

public abstract class DOMFactory {
    private static final ThreadLocal singlePerThread = new ThreadLocal();
    private static Log logCat = LogFactory.getLog((String)DOMFactory.class.getName());
    private static String factoryClass = "org.dbforms.dom.DOMFactoryXALANImpl";

    protected DOMFactory() {
    }

    public static DOMFactory instance() {
        DOMFactory fact = (DOMFactory)singlePerThread.get();
        if (fact == null) {
            try {
                fact = (DOMFactory)ReflectionUtil.newInstance(factoryClass);
            }
            catch (Exception e) {
                logCat.error((Object)"instance", (Throwable)e);
            }
            if (fact == null) {
                fact = new DOMFactoryXALANImpl();
            }
            singlePerThread.set(fact);
        }
        return fact;
    }

    public abstract String DOM2String(Document var1);

    public abstract Document String2DOM(String var1);

    public abstract Document newDOMDocument();

    public abstract Document read(InputStream var1);

    public Document read(String url) {
        Document doc = null;
        if (!Util.isNull(url)) {
            InputStream in = null;
            String path = null;
            URL u = null;
            try {
                u = new URL(url);
                path = u.getPath();
            }
            catch (Exception e) {
                path = url;
            }
            if (u != null) {
                try {
                    URLConnection con = u.openConnection();
                    con.connect();
                    in = con.getInputStream();
                }
                catch (Exception e) {
                    logCat.error((Object)"read", (Throwable)e);
                }
            }
            if (in == null) {
                try {
                    in = new FileInputStream(path);
                }
                catch (Exception e) {
                    logCat.error((Object)"read", (Throwable)e);
                }
            }
            if (in != null) {
                doc = this.read(in);
                try {
                    in.close();
                }
                catch (Exception e) {
                    logCat.error((Object)"read", (Throwable)e);
                }
            }
        }
        return doc;
    }

    public abstract void write(OutputStream var1, Element var2) throws IOException;

    public void write(OutputStream out, Document doc) throws IOException {
        this.write(out, doc.getDocumentElement());
    }

    public final void write(String url, Document doc) throws IOException {
        this.write(url, doc.getDocumentElement());
    }

    public final void write(String url, Element root) throws IOException {
        if (!Util.isNull(url) && root != null) {
            OutputStream out = null;
            try {
                URL u = new URL(url);
                URLConnection con = u.openConnection();
                con.connect();
                out = con.getOutputStream();
            }
            catch (Exception e) {
                logCat.error((Object)"write", (Throwable)e);
            }
            if (out == null) {
                try {
                    out = new FileOutputStream(url);
                }
                catch (Exception e) {
                    logCat.error((Object)"write", (Throwable)e);
                }
            }
            if (out != null) {
                this.write(out, root);
                out.close();
            } else {
                throw new IOException("no target found to wich we can write");
            }
        }
    }

    public abstract XPathEvaluator newXPathEvaluator();

    public static void setFactoryClass(String string) {
        factoryClass = string;
    }
}

