/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.conprovider;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.conprovider.ConnectionProvider;
import org.dbforms.conprovider.ConnectionProviderPrefs;

public class ConnectionFactory {
    private static ConnectionFactory instance = null;
    private ConnectionProvider provider = null;
    private Log cat = LogFactory.getLog(this.getClass());

    private ConnectionFactory() {
    }

    public static synchronized ConnectionFactory instance() {
        if (instance == null) {
            instance = new ConnectionFactory();
        }
        return instance;
    }

    public Connection getConnection() throws SQLException {
        return this.provider.getConnection();
    }

    public Connection getConnection(int isolationLevel) throws SQLException {
        return this.provider.getConnection(isolationLevel);
    }

    public void setProvider(ConnectionProviderPrefs prefs) throws Exception {
        String providerClass = prefs.getConnectionProviderClass();
        this.provider = (ConnectionProvider)Class.forName(providerClass).newInstance();
        this.provider.setPrefs(prefs);
        this.provider.init();
        this.cat.info((Object)("::setProvider - ConnectionProvider [" + providerClass + "] successfully set and initialized"));
    }
}

