/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValue;
import org.dbforms.config.Table;
import org.dbforms.util.Util;

public class Query
extends Table {
    private static Log logCat = LogFactory.getLog(Query.class);
    private String distinct = "false";
    private String followAfterWhere = " AND ";
    private String from;
    private String groupBy;
    private String having;
    private String orderWithPos = "false";
    private String where;
    private Hashtable searchNameHash = new Hashtable();
    private Vector searchfields = new Vector();

    public void setDistinct(String value) {
        this.distinct = value;
    }

    @Override
    public Field getField(int fieldId) {
        Field f = null;
        if (this.checkFieldId(1, fieldId)) {
            f = (Field)this.searchfields.elementAt(this.decodeFieldId(1, fieldId));
        } else {
            Table t;
            try {
                f = super.getField(fieldId);
            }
            catch (RuntimeException e) {
                f = null;
            }
            if (f == null && !Util.isNull(this.from) && Query.getConfig() != null && (t = Query.getConfig().getTableByName(this.from)) != null) {
                f = t.getField(fieldId);
            }
        }
        return f;
    }

    @Override
    public Field getFieldByName(String name) {
        Table t;
        Field f = super.getFieldByName(name);
        if (f == null) {
            f = (Field)this.searchNameHash.get(name);
        }
        if (f == null && !Util.isNull(this.from) && Query.getConfig() != null && (t = Query.getConfig().getTableByName(this.from)) != null) {
            f = t.getFieldByName(name);
        }
        return f;
    }

    @Override
    public Vector getFields() {
        Table t;
        Vector f = super.getFields();
        if ((f == null || f.isEmpty() && !Util.isNull(this.from)) && Query.getConfig() != null && (t = Query.getConfig().getTableByName(this.from)) != null) {
            f = t.getFields();
        }
        return f;
    }

    public void setFollowAfterWhere(String followAfterWhere) {
        this.followAfterWhere = followAfterWhere;
    }

    public void setFrom(String value) {
        this.from = value;
    }

    public void setGroupBy(String value) {
        this.groupBy = value;
    }

    public void setHaving(String value) {
        this.having = value;
    }

    public String getHaving() {
        return this.having;
    }

    @Override
    public Vector getKey() {
        Table t;
        Vector v = super.getKey();
        if ((v == null || v.isEmpty()) && !Util.isNull(this.from) && Query.getConfig() != null && (t = Query.getConfig().getTableByName(this.from)) != null) {
            v = t.getKey();
        }
        return v;
    }

    @Override
    public Hashtable getNamesHashtable(String core) {
        Hashtable result = super.getNamesHashtable(core);
        Enumeration e = this.getSearchFields().elements();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            result.put(f.getName(), f.getFieldName(core));
        }
        return result;
    }

    public void setOrderWithPos(String value) {
        this.orderWithPos = value;
    }

    @Override
    public String getQueryFrom() {
        String res = !Util.isNull(this.from) ? this.from : super.getQueryFrom();
        return res;
    }

    @Override
    public String getQuerySelect(Vector fieldsToSelect) {
        if (fieldsToSelect != null) {
            StringBuffer buf = new StringBuffer();
            int fieldsToSelectSize = fieldsToSelect.size();
            for (int i = 0; i < fieldsToSelectSize; ++i) {
                Field f = (Field)fieldsToSelect.elementAt(i);
                if (!Util.isNull(f.getExpression())) {
                    buf.append(f.getExpression());
                    buf.append(" ");
                }
                buf.append(f.getName());
                buf.append(", ");
            }
            if (buf.length() > 1) {
                buf.deleteCharAt(buf.length() - 2);
            }
            return buf.toString();
        }
        return "*";
    }

    public Vector getSearchFields() {
        return this.searchfields;
    }

    @Override
    public String getSelectQuery(Vector fieldsToSelect, FieldValue[] fvEqual, FieldValue[] fvOrder, String sqlFilter, int compareMode) {
        StringBuffer buf = new StringBuffer();
        boolean hatSchonWhere = false;
        boolean hatSchonFollowAfterWhere = false;
        boolean hatSchonHaving = false;
        FieldValue[] fvHaving = this.getFieldValueHaving(fvEqual);
        FieldValue[] fvWhere = this.getFieldValueWhere(fvEqual);
        buf.append("SELECT ");
        if (this.hasDistinctSet()) {
            buf.append(" DISTINCT ");
        }
        buf.append(this.getQuerySelect(fieldsToSelect));
        buf.append(" FROM ");
        buf.append(this.getQueryFrom());
        String s = this.getQueryWhere(fvWhere, null, 0);
        if (!(Util.isNull(s) && Util.isNull(this.where) && Util.isNull(sqlFilter))) {
            hatSchonWhere = true;
            buf.append(" WHERE ");
            if (!Util.isNull(this.where)) {
                buf.append("( ");
                buf.append(this.where);
                buf.append(" ) ");
            }
            if (!Util.isNull(sqlFilter)) {
                if (!Util.isNull(this.where)) {
                    hatSchonFollowAfterWhere = true;
                    buf.append(this.followAfterWhere);
                }
                buf.append(" ( ");
                buf.append(sqlFilter);
                buf.append(" ) ");
            }
            if (!Util.isNull(s)) {
                if (!Util.isNull(sqlFilter)) {
                    buf.append(" AND ");
                } else if (!Util.isNull(this.where)) {
                    hatSchonFollowAfterWhere = true;
                    buf.append(this.followAfterWhere);
                }
                buf.append(" ( ");
                buf.append(s);
                buf.append(" ) ");
            }
        }
        if (!Util.isNull(this.groupBy)) {
            buf.append(" GROUP BY ");
            buf.append(this.groupBy);
        }
        if (!Util.isNull(s = this.getQueryWhere(fvHaving, fvOrder, compareMode))) {
            if (!Util.isNull(this.groupBy)) {
                buf.append(" HAVING ( ");
                hatSchonHaving = true;
            } else if (!hatSchonWhere) {
                buf.append(" WHERE ( ");
            } else if (!Util.isNull(this.where) && !hatSchonFollowAfterWhere) {
                buf.append(" ");
                buf.append(this.followAfterWhere);
                buf.append(" (");
            } else {
                buf.append(" AND (");
            }
            buf.append(s);
            buf.append(")");
        }
        if (!Util.isNull(this.groupBy) && !Util.isNull(this.getHaving())) {
            if (!hatSchonHaving) {
                buf.append(" HAVING ");
            } else {
                buf.append(" AND ");
            }
            buf.append("(");
            buf.append(this.getHaving());
            buf.append(") ");
        }
        if ((s = this.getQueryOrderBy(fvOrder)).length() > 0) {
            buf.append(" ORDER BY ");
            buf.append(s);
        }
        logCat.info((Object)("doSelect:" + buf.toString()));
        return buf.toString();
    }

    public void setWhere(String value) {
        this.where = value;
    }

    public void addSearchField(Field field) throws Exception {
        if (field.getType() == 0) {
            throw new Exception("no type!");
        }
        field.setId(this.encodeFieldId(1, this.searchfields.size()));
        field.setTable(this);
        this.searchfields.addElement(field);
        this.searchNameHash.put(field.getName(), field);
    }

    public boolean hasDistinctSet() {
        return Util.getTrue(this.distinct);
    }

    public boolean needOrderWithPos() {
        return !Util.isNull(this.groupBy) || Util.getTrue(this.orderWithPos);
    }

    @Override
    public int populateWhereEqualsClause(FieldValue[] fvEqual, PreparedStatement ps, int curCol) throws SQLException {
        curCol = super.populateWhereEqualsClause(this.getFieldValueWhere(fvEqual), ps, curCol);
        curCol = super.populateWhereEqualsClause(this.getFieldValueHaving(fvEqual), ps, curCol);
        return curCol;
    }

    @Override
    protected String getQueryOrderBy(FieldValue[] fvOrder) {
        String res;
        if (!this.needOrderWithPos()) {
            res = super.getQueryOrderBy(fvOrder);
        } else {
            StringBuffer buf = new StringBuffer();
            if (fvOrder != null) {
                for (int i = 0; i < fvOrder.length; ++i) {
                    buf.append(fvOrder[i].getField().getId() + 1);
                    if (fvOrder[i].getSortDirection() == 1) {
                        buf.append(" DESC");
                    }
                    if (i >= fvOrder.length - 1) continue;
                    buf.append(",");
                }
            }
            res = buf.toString();
        }
        return res;
    }

    private FieldValue[] getFieldValueHaving(FieldValue[] fvEqual) {
        Vector<FieldValue> mode_having = new Vector<FieldValue>();
        if (fvEqual != null) {
            for (int i = 0; i < fvEqual.length; ++i) {
                if (this.checkFieldId(1, fvEqual[i].getField().getId())) continue;
                mode_having.add(fvEqual[i]);
            }
        }
        FieldValue[] fvHaving = new FieldValue[mode_having.size()];
        for (int i = 0; i < mode_having.size(); ++i) {
            fvHaving[i] = (FieldValue)mode_having.elementAt(i);
        }
        return fvHaving;
    }

    private FieldValue[] getFieldValueWhere(FieldValue[] fvEqual) {
        Vector<FieldValue> mode_where = new Vector<FieldValue>();
        if (fvEqual != null) {
            for (int i = 0; i < fvEqual.length; ++i) {
                if (!this.checkFieldId(1, fvEqual[i].getField().getId())) continue;
                mode_where.add(fvEqual[i]);
            }
        }
        FieldValue[] fvWhere = new FieldValue[mode_where.size()];
        for (int i = 0; i < mode_where.size(); ++i) {
            fvWhere[i] = (FieldValue)mode_where.elementAt(i);
        }
        return fvWhere;
    }
}

