/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbConnectionProperty;
import org.dbforms.util.Util;

public class EventInfo
implements Serializable {
    private static Log logCat = LogFactory.getLog((String)EventInfo.class.getName());
    private Properties properties = new Properties();
    private String className = null;
    private String id = null;
    private String type = null;

    public EventInfo() {
    }

    public EventInfo(String type, String className) {
        this();
        this.type = type;
        this.className = className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return !Util.isNull(this.id) ? this.id : this.type;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void addProperty(DbConnectionProperty property) {
        String name = property.getName();
        String value = property.getValue();
        this.properties.put(name, value);
        logCat.info((Object)("::addProperty - added the property [" + name + ", " + value + "] to event [" + this.getId() + "]"));
    }

    public String toString() {
        return new StringBuffer("event: id = ").append(this.getId()).append("; type = ").append(this.type).append("; className = ").append(this.className).toString();
    }
}

