/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbConnection;
import org.dbforms.config.Interceptor;
import org.dbforms.config.Table;
import org.dbforms.dom.DOMFactory;
import org.dbforms.util.IEscaper;
import org.dbforms.util.ReflectionUtil;
import org.dbforms.util.Util;

public class DbFormsConfig {
    public static final String CONFIG = "dbformsConfig";
    private ArrayList dbConnectionsList = new ArrayList();
    private DbConnection defaultDbConnection;
    private IEscaper escaper = null;
    private Hashtable dbConnectionsHash = new Hashtable();
    private Hashtable tableNameHash = new Hashtable();
    private Log logCat = LogFactory.getLog((String)this.getClass().getName());
    private ServletConfig servletConfig;
    private String defaultEscaperClass = "org.dbforms.util.DefaultEscaperImpl";
    private String defaultFormatterClass = "org.dbforms.util.DefaultFormatEmbeddedDataImpl";
    private String realPath;
    private Vector interceptors = new Vector();
    private Vector tables = new Vector();

    public DbFormsConfig(String realPath) {
        this.setRealPath(realPath);
    }

    public Connection getConnection() throws IllegalArgumentException, SQLException {
        return this.getConnection(null);
    }

    public Connection getConnection(String dbConnectionName) throws IllegalArgumentException, SQLException {
        DataSource dbConnection = null;
        Connection con = null;
        dbConnection = this.getDataSource(dbConnectionName);
        if (dbConnection == null) {
            throw new IllegalArgumentException("No DbConnection object configured with name '" + dbConnectionName + "'");
        }
        con = dbConnection.getConnection();
        if (con == null) {
            throw new IllegalArgumentException("JDBC-Troubles:  was not able to create connection from " + dbConnection);
        }
        return con;
    }

    public void setDOMFactoryClass(String string) {
        DOMFactory.setFactoryClass(string);
    }

    public DataSource getDataSource(String dbConnectionName) {
        DataSource ds;
        DbConnection connection = null;
        if (!Util.isNull(dbConnectionName)) {
            try {
                connection = (DbConnection)this.dbConnectionsList.get(Integer.parseInt(dbConnectionName));
            }
            catch (Exception ex) {
                connection = null;
            }
            if (connection == null) {
                connection = (DbConnection)this.dbConnectionsHash.get(dbConnectionName);
            }
        }
        if (connection == null) {
            connection = this.defaultDbConnection;
        }
        if (connection != null && !Util.isNull(connection.getContextDataSource()) && (ds = (DataSource)this.getServletContext().getAttribute(connection.getContextDataSource())) != null) {
            return ds;
        }
        return connection;
    }

    public void setDefaultEscaperClass(String string) {
        this.defaultEscaperClass = string;
    }

    public String getDefaultEscaperClass() {
        return this.defaultEscaperClass;
    }

    public void setDefaultFormatterClass(String string) {
        this.defaultFormatterClass = string;
    }

    public String getDefaultFormatterClass() {
        return this.defaultFormatterClass;
    }

    public IEscaper getEscaper() {
        String s;
        if (this.escaper == null && !Util.isNull(s = this.getDefaultEscaperClass())) {
            try {
                this.escaper = (IEscaper)ReflectionUtil.newInstance(s);
            }
            catch (Exception e) {
                this.logCat.error((Object)("cannot create the new escaper [" + s + "]"), (Throwable)e);
            }
        }
        return this.escaper;
    }

    public Vector getInterceptors() {
        return this.interceptors;
    }

    public void setRealPath(String realPath) {
        if (!Util.isNull(realPath)) {
            realPath = realPath.replace('\\', '/');
        }
        this.realPath = realPath;
    }

    public String getRealPath() {
        return this.realPath;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletConfig.getServletContext();
    }

    public Table getTable(int index) {
        try {
            return (Table)this.tables.elementAt(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Table getTableByName(String name) {
        try {
            return (Table)this.tableNameHash.get(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addDbConnection(DbConnection dbConnection) {
        dbConnection.setName(Util.replaceRealPath(dbConnection.getName(), this.realPath));
        this.dbConnectionsList.add(dbConnection);
        if (!Util.isNull(dbConnection.getId())) {
            this.dbConnectionsHash.put(dbConnection.getId(), dbConnection);
        }
        if (dbConnection.isDefaultConnection() && (this.defaultDbConnection == null || !this.defaultDbConnection.isDefaultConnection()) || this.defaultDbConnection == null) {
            this.defaultDbConnection = dbConnection;
            dbConnection.setDefaultConnection(true);
        }
        this.logCat.info((Object)("::addDbConnection - added the dbConnection [" + dbConnection + "]"));
    }

    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.addElement(interceptor);
    }

    public void addTable(Table table) {
        this.logCat.info((Object)"add table called");
        table.setId(this.tables.size());
        table.initDefaultOrder();
        this.tables.addElement(table);
        this.tableNameHash.put(table.getName(), table);
    }

    public boolean hasInterceptors() {
        return this.interceptors != null && this.interceptors.size() > 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.tables.size(); ++i) {
            Table t = (Table)this.tables.elementAt(i);
            buf.append("table:\n");
            buf.append(t.toString());
        }
        return buf.toString();
    }
}

