/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.generator.generation;

import de.destatis.core.connect.util.Contract;
import de.destatis.core.generator.AbstractDescriptor;
import de.destatis.core.generator.DataProvider;
import de.destatis.core.generator.Descriptor;
import de.destatis.core.generator.DescriptorFactory;
import de.destatis.core.generator.FieldDescriptor;
import de.destatis.core.generator.StructureDescriptor;
import de.destatis.core.map.BindingGroup;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldGroupBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.model.BindingHelper;
import de.statspez.sdf.generator.meta.SDFElementVisitor;
import de.statspez.sdf.generator.meta.generated.MetaAuspraegung;
import de.statspez.sdf.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaAuspraegungsgruppeComps;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabesatz;
import de.statspez.sdf.generator.meta.generated.MetaSDFBedingung;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.sdf.generator.util.SDFUtil;
import de.werum.sis.meta.ElementVisitorInterface;
import de.werum.sis.meta.MetaElementInterface;
import java.util.Iterator;
import java.util.Stack;

public abstract class AbstractSdfGeneratorTraverser
implements SDFElementVisitor {
    private MetaSDFAusgabegruppe currentAusgabegruppe;
    private Stack structureStack = new Stack();
    private Stack mmgrIndexStack;
    private BindingGroup mapping;
    private BindingGroup currentBindingGroup;
    private Stack mappingInfoStack;

    public AbstractSdfGeneratorTraverser(StructureDescriptor parentDescriptor, DataProvider dataProvider, BindingGroup mapping) {
        StructureStackInfo stackInfo = new StructureStackInfo(parentDescriptor, dataProvider);
        this.structureStack.push(stackInfo);
        this.mmgrIndexStack = new Stack();
        this.currentBindingGroup = this.mapping = mapping;
        if (this.mapping != null) {
            Contract.verify(this.mapping instanceof Mapping || this.mapping instanceof FieldSetBinding, "Ung\u00fcltiges mapping: " + mapping.getClass().getName());
            this.mappingInfoStack = new Stack();
        }
    }

    public String getSdfPathString(Descriptor descriptor) {
        StructureDescriptor parent = ((StructureStackInfo)this.structureStack.get(0)).getStructureDescriptor();
        String sdfPath = AbstractSdfGeneratorTraverser.getSubPathString(parent, descriptor);
        return sdfPath;
    }

    public static String getSubPathString(StructureDescriptor parent, Descriptor descriptor) {
        int parentLength = parent.getPathLength();
        String subPath = AbstractDescriptor.getSubPathString(descriptor, parentLength);
        return subPath;
    }

    protected MetaSDFAusgabegruppe getSDFAusgabegruppe() {
        return this.currentAusgabegruppe;
    }

    protected void setSdfAusgabegruppe(MetaSDFAusgabegruppe ausgabegruppe) {
        this.currentAusgabegruppe = ausgabegruppe;
    }

    protected Stack getMmmgrIndexStack() {
        return this.mmgrIndexStack;
    }

    protected StructureStackInfo getCurrentStackInfo() {
        return (StructureStackInfo)this.structureStack.peek();
    }

    public void visitAuspraegung(MetaAuspraegung auspraegung) {
    }

    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe auspraegungsgruppe) {
    }

    public void visitAuspraegungsgruppeComps(MetaAuspraegungsgruppeComps auspraegungsgruppeComps) {
    }

    public void visitErhebungsbeschreibung(MetaErhebungsbeschreibung erhebungsbeschreibung) {
    }

    public void visitMerkmal(MetaMerkmal merkmal) {
    }

    public void visitSDFAusgabesatz(MetaSDFAusgabesatz ausgabesatz) {
    }

    public void visitSDFAusgabegruppe(MetaSDFAusgabegruppe ausgabegruppe) {
        this.setSdfAusgabegruppe(ausgabegruppe);
        this.visitElements(ausgabegruppe.getSDFFeldReferenzen());
        this.setSdfAusgabegruppe(null);
    }

    public void visitSDFFeldReferenz(MetaSDFFeldReferenz feldReferenz) {
        if (this.shouldEnterSdfFeldReferenz(feldReferenz)) {
            MetaStatspezObjekt metaStatspezObjekt = feldReferenz.getKlasse();
            if (feldReferenz.getArt() == 2) {
                if (this.shouldEnterSdfMerkmalsgruppe((MetaSDFMerkmalsgruppe)metaStatspezObjekt)) {
                    int stop;
                    if (this.mapping != null) {
                        MmgrMappingInfo mappingInfo = new MmgrMappingInfo((MetaSDFMerkmalsgruppe)metaStatspezObjekt, this.currentBindingGroup);
                        this.mappingInfoStack.push(mappingInfo);
                    }
                    int minOccurs = SDFUtil.getMinOccurs((String)feldReferenz.getMinimaleAnzahl());
                    int maxOccurs = SDFUtil.getMaxOccurs((String)feldReferenz.getMaximaleAnzahl());
                    int anzahl = 0;
                    if (minOccurs == 1 && maxOccurs == 1) {
                        stop = 1;
                    } else {
                        stop = maxOccurs;
                        if (stop == -1) {
                            stop = Integer.MAX_VALUE;
                        }
                    }
                    for (int index = 0; index < stop; ++index) {
                        this.mmgrIndexStack.push(new Integer(index));
                        try {
                            metaStatspezObjekt.accept((ElementVisitorInterface)this);
                            ++anzahl;
                        }
                        catch (BreakMmgrIndexLoop breakExc) {
                            this.mmgrIndexStack.pop();
                            break;
                        }
                        this.mmgrIndexStack.pop();
                    }
                    this.doHandleMerkmalsgruppeAnzahl((MetaSDFMerkmalsgruppe)metaStatspezObjekt, anzahl);
                    if (this.mapping != null) {
                        this.mappingInfoStack.pop();
                    }
                }
            } else if (this.shouldEnterSdfMerkmal((MetaSDFMerkmal)metaStatspezObjekt)) {
                metaStatspezObjekt.accept((ElementVisitorInterface)this);
            }
        }
    }

    protected abstract boolean shouldEnterSdfFeldReferenz(MetaSDFFeldReferenz var1);

    protected boolean shouldEnterSdfMerkmalsgruppe(MetaSDFMerkmalsgruppe merkmalsgruppe) {
        return true;
    }

    protected boolean shouldEnterSdfMerkmal(MetaSDFMerkmal merkmal) {
        return true;
    }

    public void visitSDFMerkmal(MetaSDFMerkmal merkmal) {
        StructureStackInfo stackInfo = (StructureStackInfo)this.structureStack.peek();
        StructureDescriptor parent = stackInfo.getStructureDescriptor();
        FieldBinding fieldBinding = null;
        String customName = null;
        Integer csvPos = null;
        if (this.mapping != null) {
            fieldBinding = (FieldBinding)BindingHelper.getBindingByIdStrict(this.currentBindingGroup, merkmal.getName());
            customName = fieldBinding.getCustomName();
            csvPos = fieldBinding.getPosition();
        }
        FieldDescriptor mmDescriptor = DescriptorFactory.createFieldDescriptor(parent, merkmal, customName, csvPos);
        this.doVisitSDFMerkmal(merkmal, stackInfo, mmDescriptor, fieldBinding);
    }

    protected abstract void doVisitSDFMerkmal(MetaSDFMerkmal var1, StructureStackInfo var2, FieldDescriptor var3, FieldBinding var4);

    public void visitSDFMerkmalsgruppe(MetaSDFMerkmalsgruppe merkmalsgruppe) {
        StructureDescriptor mmgrDescriptor;
        DataProvider mmgrDataProvider;
        StructureStackInfo stackInfo = (StructureStackInfo)this.structureStack.peek();
        StructureDescriptor parent = stackInfo.getStructureDescriptor();
        DataProvider dataProvider = stackInfo.getDataProvider();
        Integer index = (Integer)this.mmgrIndexStack.peek();
        FieldGroupBinding fieldGroupBinding = null;
        Integer quantity = null;
        String customName = null;
        Integer firstCsvPosition = null;
        Integer lastCsvPosition = null;
        if (this.mapping != null) {
            MmgrMappingInfo mappingInfo = (MmgrMappingInfo)this.mappingInfoStack.peek();
            fieldGroupBinding = mappingInfo.getBinding();
            quantity = mappingInfo.getQuantity();
            firstCsvPosition = mappingInfo.getFirstCsvPosition();
            lastCsvPosition = mappingInfo.getLastCsvPosition();
        }
        if ((mmgrDataProvider = dataProvider.getDataProvider(mmgrDescriptor = DescriptorFactory.createMmgrDescriptor(parent, merkmalsgruppe, index, customName, quantity, firstCsvPosition, lastCsvPosition))) != null) {
            this.doEnterMerkmalsgruppe(merkmalsgruppe, stackInfo, mmgrDescriptor);
            StructureStackInfo mmgrStackInfo = new StructureStackInfo(mmgrDescriptor, mmgrDataProvider);
            this.structureStack.push(mmgrStackInfo);
            if (this.mapping != null) {
                this.currentBindingGroup = fieldGroupBinding;
            }
            this.visitElements(merkmalsgruppe.getSDFFeldReferenzen());
            if (this.mapping != null) {
                this.currentBindingGroup = this.currentBindingGroup.getParent();
            }
            this.structureStack.pop();
            this.doLeaveMerkmalsgruppe(merkmalsgruppe, stackInfo, mmgrDescriptor);
        } else if (index != null) {
            throw new BreakMmgrIndexLoop();
        }
    }

    protected abstract void doEnterMerkmalsgruppe(MetaSDFMerkmalsgruppe var1, StructureStackInfo var2, StructureDescriptor var3);

    protected abstract void doLeaveMerkmalsgruppe(MetaSDFMerkmalsgruppe var1, StructureStackInfo var2, StructureDescriptor var3);

    protected void doHandleMerkmalsgruppeAnzahl(MetaSDFMerkmalsgruppe merkmalsgruppe, int anzahl) {
    }

    public void visitSDFBedingung(MetaSDFBedingung bedingung) {
    }

    protected void visitElements(Iterator it) {
        while (it.hasNext()) {
            MetaElementInterface e = (MetaElementInterface)it.next();
            if (e == null) continue;
            e.accept((ElementVisitorInterface)this);
        }
    }

    public static class MmgrMappingInfo {
        private FieldGroupBinding fieldGroupBinding = null;
        private BindingHelper.MinAndMax firstAndLastCsvPos = null;
        private Integer firstCsvPosition = null;
        private Integer lastCsvPosition = null;

        public MmgrMappingInfo(MetaSDFMerkmalsgruppe merkmalsgruppe, BindingGroup parentBindingGroup) {
            this.fieldGroupBinding = (FieldGroupBinding)BindingHelper.getBindingByIdStrict(parentBindingGroup, merkmalsgruppe.getName());
            this.firstAndLastCsvPos = BindingHelper.getFirstAndLastCalculatedCsvPositionForFirstIndex(this.fieldGroupBinding);
            this.firstCsvPosition = this.firstAndLastCsvPos != null ? new Integer(this.firstAndLastCsvPos.getMin()) : null;
            this.lastCsvPosition = this.firstAndLastCsvPos != null ? new Integer(this.firstAndLastCsvPos.getMax()) : null;
        }

        public FieldGroupBinding getBinding() {
            return this.fieldGroupBinding;
        }

        public String getCustomName() {
            return this.fieldGroupBinding.getCustomName();
        }

        public Integer getQuantity() {
            return this.fieldGroupBinding.getSize();
        }

        public Integer getFirstCsvPosition() {
            return this.firstCsvPosition;
        }

        public Integer getLastCsvPosition() {
            return this.lastCsvPosition;
        }
    }

    protected static class BreakMmgrIndexLoop
    extends RuntimeException {
        protected BreakMmgrIndexLoop() {
        }
    }

    protected static class StructureStackInfo {
        private StructureDescriptor structureDescriptor;
        private DataProvider dataProvider;

        public StructureStackInfo(StructureDescriptor structureDescriptor, DataProvider dataProvider) {
            this.structureDescriptor = structureDescriptor;
            this.dataProvider = dataProvider;
        }

        public StructureDescriptor getStructureDescriptor() {
            return this.structureDescriptor;
        }

        public DataProvider getDataProvider() {
            return this.dataProvider;
        }
    }

    public static class GenerationException
    extends RuntimeException {
        protected GenerationException(Exception cause) {
            super(cause);
        }

        protected GenerationException(String message) {
            super(message);
        }

        protected GenerationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

