/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.util.IBodyTag;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class RefTag
extends HTMLTag
implements IBodyTag {
    public RefTag() {
        super("ref");
    }

    public void renderHTML(ITextConverter converter, Appendable writer, IWikiModel model) throws IOException {
        RefTag node = this;
        List<Object> children = node.getChildren();
        int len = children.size();
        StringBuilder buf = null;
        buf = len == 0 ? new StringBuilder() : new StringBuilder(len * 64);
        this.renderHTMLWithoutTag(converter, buf, model);
        Map<String, String> map = this.getAttributes();
        String value = map.get("name");
        String reference = buf.toString();
        String[] offset = model.addToReferences(reference, value);
        if (null == value) {
            value = offset[0];
        }
        String ref = null == offset[1] ? offset[0] : offset[1];
        writer.append("<sup id=\"_ref-");
        writer.append(Encoder.encodeDotUrl(ref));
        writer.append("\" class=\"reference\"><a href=\"#_note-");
        writer.append(Encoder.encodeDotUrl(value));
        writer.append("\" title=\"\">[");
        writer.append(offset[0]);
        writer.append("]</a></sup>");
    }

    public boolean isReduceTokenStack() {
        return false;
    }
}

