/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.Utils;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.WPList;
import info.bliki.wiki.filter.WPTable;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainTextConverter
implements ITextConverter {
    boolean fNoLinks;

    public PlainTextConverter(boolean noLinks) {
        this.fNoLinks = noLinks;
    }

    public PlainTextConverter() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodesToText(List<? extends Object> nodes, Appendable resultBuffer, IWikiModel model) throws IOException {
        if (nodes != null && !nodes.isEmpty()) {
            try {
                int level = model.incrementRecursionLevel();
                if (level > 256) {
                    resultBuffer.append("Error - recursion limit exceeded rendering tags in PlainTextConverter#nodesToText().");
                    return;
                }
                for (Object object : nodes) {
                    TagNode node;
                    Map<String, Object> map;
                    if (object == null) continue;
                    if (object instanceof List) {
                        this.nodesToText((List)object, resultBuffer, model);
                        continue;
                    }
                    if (object instanceof ContentToken) {
                        ContentToken contentToken = (ContentToken)object;
                        String content = contentToken.getContent();
                        Utils.escapeXmlToBuffer(content, resultBuffer, true, true, true);
                        continue;
                    }
                    if (object instanceof WPList) {
                        ((WPList)object).renderPlainText(this, resultBuffer, model);
                        continue;
                    }
                    if (object instanceof WPTable) {
                        ((WPTable)object).renderPlainText(this, resultBuffer, model);
                        continue;
                    }
                    if (object instanceof HTMLTag) {
                        ((HTMLTag)object).getBodyString(resultBuffer);
                        continue;
                    }
                    if (!(object instanceof TagNode) || (map = (node = (TagNode)object).getObjectAttributes()) != null && map.size() > 0) continue;
                    node.getBodyString(resultBuffer);
                }
            }
            finally {
                model.decrementRecursionLevel();
            }
        }
    }

    @Override
    public boolean noLinks() {
        return this.fNoLinks;
    }

    @Override
    public void imageNodeToText(TagNode imageTagNode, ImageFormat imageFormat, Appendable resultBuffer, IWikiModel model) throws IOException {
    }
}

