/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.util.ServletHelper;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.UserInitializer;
import de.superx.util.SqlStringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class AbstractSuperXServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public String getTid(HttpServletRequest request) {
        String tidString = ServletHelper.getParameter(request, "tid");
        if (tidString == null || tidString.equals("")) {
            throw new IllegalArgumentException("tid Argument fehlt");
        }
        return tidString;
    }

    public void checkCacheClearing(HttpServletRequest request) throws ServletException {
        String p = ServletHelper.getParameter(request, "cachingcontrol");
        if (p != null) {
            if (p.equalsIgnoreCase("clearstylesheets") || p.equalsIgnoreCase("s")) {
                try {
                    SuperXManager.clearTransletStylesheets();
                }
                catch (Exception e2) {
                    throw new ServletException(e2.toString());
                }
            }
            if (p.equalsIgnoreCase("clearall") || p.equalsIgnoreCase("a")) {
                try {
                    SuperXManager.initPool(request, ServletUtils.getMandantenID(request));
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                    throw new IllegalArgumentException("Kann Cache nicht neu laden:" + e3);
                }
            }
        }
    }

    protected void forward(HttpServletRequest request, HttpServletResponse response, String uri) throws IOException, ServletException {
        String url = response.encodeRedirectURL("/servlet/" + uri);
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(url);
        if (rd == null) {
            throw new IOException("Konnte keinen RequestDispatch aufbauen f\u00fcr /servlet/" + uri);
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void erstmalAnmelden(String servlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/servlet/de.superx.servlet.SuperXmlAnmeldung?requestedServlet=" + servlet);
        if (rd == null) {
            throw new IOException("Konnte keinen RequestDispatch aufbauen f\u00fcr /servlet/de.superx.servlet.SuperXmlAnmeldung");
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean hasProperSession(HttpServletRequest request) {
        String type;
        boolean result = false;
        HttpSession s = request.getSession();
        if (s != null && (type = (String)s.getAttribute("sessiontype")) != null && type.equals("superx")) {
            result = true;
        }
        return result;
    }

    public void checkAnmeldungImRequest(HttpServletRequest request) throws IOException, ServletException {
        if (ServletHelper.getParameter(request, "token") != null || ServletHelper.getParameter(request, "kennung") != null && ServletHelper.getParameter(request, "passwort") != null) {
            UserInitializer ui = new UserInitializer(request, false);
            try {
                ui.perform();
            }
            catch (Exception e2) {
                throw new ServletException("Authentification for " + ServletHelper.getParameter(request, "kennung") + " failed (" + e2 + ")");
            }
        }
    }

    protected boolean isJSONRequest(HttpServletRequest request) {
        boolean result = false;
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String aName = (String)en.nextElement();
            if (!aName.startsWith("getJSON")) continue;
            result = true;
        }
        return result;
    }

    protected static void setEncoding(HttpServletRequest request) throws UnsupportedEncodingException {
        String ie = SqlStringUtils.getEncoding();
        request.setCharacterEncoding(ie);
    }
}

