/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.IdObject;
import de.superx.common.DBServletException;
import de.superx.common.LocalizedItem;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.servlet.ServletUtils;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;

public class TranslationContainer
extends IdObject {
    private static final long serialVersionUID = 1L;
    private Collection localizedItems = new LinkedList();
    public static final Locale defaultLocale = new Locale("de");
    public static final Locale DE_LOCALE = new Locale("de");
    public static final Locale EN_LOCALE = new Locale("en");

    public TranslationContainer(String mandantenID, Object id) throws SQLException, DBServletException {
        super(id);
        SxResultSet rs = ServletUtils.execute("Einlesen von \u00dcbersetzungen", "select locale,contents_short,contents_long from sx_captions where id='" + this.getId() + "'", mandantenID);
        for (SxResultRow row : rs) {
            LocalizedItem item = new LocalizedItem();
            String locale = row.get(0).toString();
            Locale l2 = null;
            if (locale.equals("de")) {
                l2 = DE_LOCALE;
            } else if (locale.equals("en")) {
                l2 = EN_LOCALE;
            } else if (locale != null && !locale.trim().equals("")) {
                l2 = new Locale(locale);
            }
            item.setLocale(l2);
            item.setContentsShort((String)row.get(1));
            item.setContentsLong((String)row.get(2));
            this.localizedItems.add(item);
        }
    }

    public String getContentsShort(Locale l2) {
        String result = "";
        for (LocalizedItem item : this.localizedItems) {
            if (item.getLocale() == null) {
                result = item.getContentsShort();
                continue;
            }
            if (!item.getLocale().getLanguage().equals(l2.getLanguage())) continue;
            result = item.getContentsShort();
            break;
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public String getContentsLong(Locale l2) {
        String result = "";
        for (LocalizedItem item : this.localizedItems) {
            if (item.getLocale() == null) {
                result = item.getContentsLong();
                continue;
            }
            if (!item.getLocale().getLanguage().equals(l2.getLanguage())) continue;
            result = item.getContentsLong();
            break;
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("id: " + this.getId() + " - ");
        for (LocalizedItem item : this.localizedItems) {
            result.append(String.valueOf(item.toString()) + " ");
        }
        return result.toString();
    }
}

