/*
 * Decompiled with CFR 0.152.
 */
package de.superx.applet;

import de.superx.applet.SxTableMap;
import de.superx.applet.SxTableModel;
import java.util.Date;
import java.util.Vector;
import javax.swing.event.TableModelEvent;

public class SxTableSorter
extends SxTableMap {
    int[] indexes;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    int compares;

    public SxTableSorter() {
        this.indexes = new int[0];
    }

    public SxTableSorter(SxTableModel model) {
        this.setModel(model);
    }

    @Override
    public void setModel(SxTableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
    }

    public int[] getIndexes() {
        return this.indexes;
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Object v2;
        String s2;
        Class<?> type = this.model.getColumnClass(column);
        SxTableModel data = this.model;
        Object o1 = data.getObjectAt(row1, column);
        Object o2 = data.getObjectAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == Number.class) {
            Number n2;
            double d2;
            Number n1 = (Number)data.getObjectAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)data.getObjectAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)data.getObjectAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)data.getObjectAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            String s22;
            String s1 = (String)data.getObjectAt(row1, column);
            int result = s1.compareTo(s22 = (String)data.getObjectAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)data.getObjectAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)data.getObjectAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        Object v1 = data.getObjectAt(row1, column);
        String s1 = v1.toString();
        int result = s1.compareTo(s2 = (v2 = data.getObjectAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        int level = 0;
        while (level < this.sortingColumns.size()) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result != 0) {
                return this.ascending ? result : -result;
            }
            ++level;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        int row = 0;
        while (row < rowCount) {
            this.indexes[row] = row;
            ++row;
        }
    }

    @Override
    public void tableChanged(TableModelEvent e2) {
        this.reallocateIndexes();
        super.tableChanged(e2);
    }

    public void dataChanged() {
        this.reallocateIndexes();
        this.sort(this);
        super.tableChanged(new TableModelEvent(this, 0, this.getRowCount()));
    }

    public void checkModel() {
        int cfr_ignored_0 = this.indexes.length;
        this.model.getRowCount();
    }

    public void sort(Object sender) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void n2sort() {
        int i2 = 0;
        while (i2 < this.getRowCount()) {
            int j2 = i2 + 1;
            while (j2 < this.getRowCount()) {
                if (this.compare(this.indexes[i2], this.indexes[j2]) == -1) {
                    this.swap(i2, j2);
                }
                ++j2;
            }
            ++i2;
        }
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            int i2 = low;
            while (i2 < high) {
                to[i2] = from[i2];
                ++i2;
            }
            return;
        }
        int i3 = low;
        while (i3 < high) {
            to[i3] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
            ++i3;
        }
    }

    public void swap(int i2, int j2) {
        int tmp = this.indexes[i2];
        this.indexes[i2] = this.indexes[j2];
        this.indexes[j2] = tmp;
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    @Override
    public Object getObjectAt(int aRow, int aColumn) {
        this.checkModel();
        return this.model.getObjectAt(this.indexes[aRow], aColumn);
    }

    @Override
    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    @Override
    public void setDataVector(Vector rows, Vector header, Object meta) {
        this.indexes = new int[rows.size()];
        this.model.setDataVector(rows, header, meta);
    }

    @Override
    public void setDataVector(Vector Rows) {
        this.indexes = new int[Rows.size()];
        this.model.setDataVector(Rows);
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, true);
    }

    public void sortByColumn(int column, boolean ascending) {
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        this.sort(this);
        super.tableChanged(new TableModelEvent(this, 0, this.getRowCount()));
    }
}

