/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.widgets;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import javax.swing.JEditorPane;
import javax.swing.RepaintManager;

public class PrintableEditorPane
extends JEditorPane
implements Printable,
Serializable {
    public PrintableEditorPane() {
    }

    public PrintableEditorPane(String type, String text) {
        super(type, text);
    }

    @Override
    public int print(Graphics g2, PageFormat pf, int pageIndex) throws PrinterException {
        int totalNumPages;
        Graphics2D g22 = (Graphics2D)g2;
        g22.setColor(Color.black);
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        Dimension d2 = this.getSize();
        double panelWidth = d2.width;
        double panelHeight = d2.height;
        double pageWidth = pf.getImageableWidth();
        double pageHeight = pf.getImageableHeight();
        double scale = 1.0;
        if (panelWidth > pageWidth) {
            scale = pageWidth / panelWidth;
        }
        if (pageIndex >= (totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight))) {
            return 1;
        }
        g22.translate(pf.getImageableX(), pf.getImageableY());
        g22.translate(0.0, (double)(-pageIndex) * pageHeight);
        g22.scale(scale, scale);
        this.paint(g22);
        return 0;
    }
}

