/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.icons;

import de.memtext.icons.ArrowRight;
import de.memtext.widgets.MBFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JButton;

public abstract class BasicIcon
implements Icon {
    private int iconWidth = 16;
    private int iconHeight = 16;
    private Color color = Color.black;

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x, int y) {
        g2.translate(x, y);
        if (c2.isEnabled()) {
            g2.setColor(this.color);
        } else {
            g2.setColor(Color.GRAY);
        }
        this.myPaint(g2);
        g2.translate(-x, -y);
    }

    abstract void myPaint(Graphics var1);

    void drawDoubleLine(Graphics g2, int y) {
        if (y > this.getIconHeight() - 2) {
            throw new IllegalArgumentException("can't draw that low");
        }
        g2.drawLine(0, y, this.getIconWidth(), y);
        g2.drawLine(0, y + 1, this.getIconWidth(), y + 1);
    }

    void drawArrowRight(Graphics g2) {
        int midx = (int)Math.floor(this.getIconWidth() / 2);
        int midy = (int)Math.floor(this.getIconHeight() / 2);
        g2.drawLine(0, midy - 1, this.getIconWidth(), midy - 1);
        g2.drawLine(0, midy, this.getIconWidth(), midy);
        g2.drawLine(0, midy + 1, this.getIconWidth(), midy + 1);
        g2.drawLine(midx + 1, 1, this.getIconWidth(), midy - 1);
        g2.drawLine(midx + 1, 2, this.getIconWidth(), midy);
        g2.drawLine(midx + 1, this.getIconHeight() - 1, this.getIconWidth(), midy + 1);
        g2.drawLine(midx + 1, this.getIconHeight() - 2, this.getIconWidth(), midy);
    }

    void drawArrowUp(Graphics g2, int y) {
        int midx = (int)Math.floor(this.getIconWidth() / 2);
        int midy = (int)Math.floor(this.getIconHeight() / 2);
        g2.drawLine(0, y + midy, midx, y);
        g2.drawLine(midx, y, this.getIconWidth(), y + midy);
        g2.drawLine(0, y + midy + 1, midx, y + 1);
        g2.drawLine(midx, y + 1, this.getIconWidth(), y + midy + 1);
    }

    void drawArrowDown(Graphics g2, int y) {
        int midx = (int)Math.floor(this.getIconWidth() / 2);
        int midy = (int)Math.floor(this.getIconHeight() / 2);
        g2.drawLine(0, y, midx, midy + y);
        g2.drawLine(midx, y + midy, this.getIconWidth(), y);
        g2.drawLine(0, y + 1, midx, midy + y + 1);
        g2.drawLine(midx, y + midy + 1, this.getIconWidth(), y + 1);
    }

    public static void main(String[] args) {
        MBFrame f2 = new MBFrame("test");
        f2.setCenter(new JButton("test", new ArrowRight()));
        f2.pack();
        f2.show();
    }

    public void setIconHeight(int i2) {
        this.iconHeight = i2;
    }

    public void setIconWidth(int i2) {
        this.iconWidth = i2;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

