/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import com.sun.mail.imap.protocol.ENVELOPE;
import com.sun.mail.imap.protocol.FLAGS;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.INTERNALDATE;
import com.sun.mail.imap.protocol.Item;
import com.sun.mail.imap.protocol.RFC822DATA;
import com.sun.mail.imap.protocol.RFC822SIZE;
import com.sun.mail.imap.protocol.UID;
import java.io.IOException;
import java.util.Vector;

public class FetchResponse
extends IMAPResponse {
    private Item[] items;
    private static final char[] HEADER = new char[]{'.', 'H', 'E', 'A', 'D', 'E', 'R'};
    private static final char[] TEXT = new char[]{'.', 'T', 'E', 'X', 'T'};

    public FetchResponse(Protocol p) throws IOException, ProtocolException {
        super(p);
        this.parse();
    }

    public FetchResponse(IMAPResponse r) throws IOException, ProtocolException {
        super(r);
        this.parse();
    }

    public int getItemCount() {
        return this.items.length;
    }

    public Item getItem(int index) {
        return this.items[index];
    }

    public Item getItem(Class c2) {
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            if (!c2.isInstance(this.items[i2])) continue;
            return this.items[i2];
        }
        return null;
    }

    public static Item getItem(Response[] r, int msgno, Class c2) {
        if (r == null) {
            return null;
        }
        for (int i2 = 0; i2 < r.length; ++i2) {
            if (r[i2] == null || !(r[i2] instanceof FetchResponse) || ((FetchResponse)r[i2]).getNumber() != msgno) continue;
            FetchResponse f2 = (FetchResponse)r[i2];
            for (int j2 = 0; j2 < f2.items.length; ++j2) {
                if (!c2.isInstance(f2.items[j2])) continue;
                return f2.items[j2];
            }
        }
        return null;
    }

    private void parse() throws ParsingException {
        this.skipSpaces();
        if (this.buffer[this.index] != 40) {
            throw new ParsingException("error in FETCH parsing, missing '(' at index " + this.index);
        }
        Vector<ENVELOPE> v = new Vector<ENVELOPE>();
        Item i2 = null;
        do {
            ++this.index;
            if (this.index >= this.size) {
                throw new ParsingException("error in FETCH parsing, ran off end of buffer, size " + this.size);
            }
            switch (this.buffer[this.index]) {
                case 69: {
                    if (!this.match(ENVELOPE.name)) break;
                    this.index += ENVELOPE.name.length;
                    i2 = new ENVELOPE(this);
                    break;
                }
                case 70: {
                    if (!this.match(FLAGS.name)) break;
                    this.index += FLAGS.name.length;
                    i2 = new FLAGS(this);
                    break;
                }
                case 73: {
                    if (!this.match(INTERNALDATE.name)) break;
                    this.index += INTERNALDATE.name.length;
                    i2 = new INTERNALDATE(this);
                    break;
                }
                case 66: {
                    if (!this.match(BODY.name)) break;
                    if (this.buffer[this.index + 4] == 91) {
                        this.index += BODY.name.length;
                        i2 = new BODY(this);
                        break;
                    }
                    this.index = this.match(BODYSTRUCTURE.name) ? (this.index += BODYSTRUCTURE.name.length) : (this.index += BODY.name.length);
                    i2 = new BODYSTRUCTURE(this);
                    break;
                }
                case 82: {
                    if (this.match(RFC822SIZE.name)) {
                        this.index += RFC822SIZE.name.length;
                        i2 = new RFC822SIZE(this);
                        break;
                    }
                    if (!this.match(RFC822DATA.name)) break;
                    this.index += RFC822DATA.name.length;
                    if (this.match(HEADER)) {
                        this.index += HEADER.length;
                    } else if (this.match(TEXT)) {
                        this.index += TEXT.length;
                    }
                    i2 = new RFC822DATA(this);
                    break;
                }
                case 85: {
                    if (!this.match(UID.name)) break;
                    this.index += UID.name.length;
                    i2 = new UID(this);
                    break;
                }
            }
            if (i2 == null) continue;
            v.addElement((ENVELOPE)i2);
        } while (this.buffer[this.index] != 41);
        ++this.index;
        this.items = new Item[v.size()];
        v.copyInto(this.items);
    }

    private boolean match(char[] itemName) {
        int len = itemName.length;
        int i2 = 0;
        int j2 = this.index;
        while (i2 < len) {
            if (Character.toUpperCase((char)this.buffer[j2++]) == itemName[i2++]) continue;
            return false;
        }
        return true;
    }
}

