/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.testdriver.Spec;
import net.sf.saxon.testdriver.TestDriver;
import net.sf.saxon.value.DateTimeValue;

public abstract class TestReport {
    protected TestDriver testDriver;
    protected Spec spec;
    protected XMLStreamWriter results;
    protected Writer writer;
    protected String reportFilename;

    public TestReport(TestDriver testDriver, Spec sp) {
        this.testDriver = testDriver;
        this.spec = sp;
        this.reportFilename = testDriver.getResultsDir() + "/results_" + this.spec.fullName + "_" + testDriver.getProductVersion() + ".xml";
    }

    public void setReportFilename(String fn) {
        this.reportFilename = fn.contains(System.getProperty("file.separator")) ? fn : this.testDriver.getResultsDir() + "/" + fn;
        if (!this.reportFilename.contains(".")) {
            this.reportFilename = this.reportFilename + ".xml";
        }
    }

    public void createWriter(Processor processor) throws IOException, SaxonApiException {
        BufferedWriter resultWriter = new BufferedWriter(new FileWriter(this.reportFilename));
        Serializer serializer = processor.newSerializer((Writer)resultWriter);
        serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
        serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
        if (!processor.getSaxonEdition().equals("HE")) {
            serializer.setOutputProperty(Serializer.Property.SAXON_LINE_LENGTH, "120");
        }
        this.writer = resultWriter;
        this.results = serializer.getXMLStreamWriter();
    }

    public abstract void writeResultFilePreamble(Processor var1, XdmNode var2) throws IOException, SaxonApiException, XMLStreamException;

    public abstract String getReportNamespace();

    public void writeResultFilePostamble() {
        try {
            this.results.writeEndElement();
            this.results.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void startTestSetElement(XdmNode funcSetNode) {
        try {
            this.results.writeStartElement(this.getReportNamespace(), "test-set");
            this.results.writeAttribute("name", funcSetNode.attribute("name"));
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void endElement() {
        try {
            this.results.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTestcaseElement(String name, String part, String result, String comment) {
        try {
            this.results.writeEmptyElement(this.getReportNamespace(), "test-case");
            this.results.writeAttribute("name", name);
            this.results.writeAttribute("part", part);
            this.results.writeAttribute("result", result);
            if (comment != null) {
                this.results.writeAttribute("comment", comment);
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTestcaseElement(String name, String result, String comment) {
        try {
            this.results.writeEmptyElement(this.getReportNamespace(), "test-case");
            this.results.writeAttribute("name", name);
            this.results.writeAttribute("result", result);
            if (comment != null) {
                this.results.writeAttribute("comment", comment);
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDate() {
        return DateTimeValue.getCurrentDateTime(null).getStringValue().substring(0, 10);
    }

    public static String getTime() {
        return DateTimeValue.getCurrentDateTime(null).getStringValue().substring(11);
    }
}

