/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.xml;

import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomMapping;
import de.statspez.pleditor.generator.meta.MetaCustomPLMaterial;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaRawDataSet;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.Tags;
import de.statspez.pleditor.generator.xml.AbstractXmlGenerator;
import de.statspez.pleditor.generator.xml.AuspraegungsgruppeXmlGenerator;
import de.statspez.pleditor.generator.xml.DsbXmlGenerator;
import de.statspez.pleditor.generator.xml.ErhebungXmlGenerator;
import de.statspez.pleditor.generator.xml.FunktionXmlGenerator;
import de.statspez.pleditor.generator.xml.MappingXmlGenerator;
import de.statspez.pleditor.generator.xml.MerkmalXmlGenerator;
import de.statspez.pleditor.generator.xml.PLMaterialXmlGenerator;
import de.statspez.pleditor.generator.xml.RawDsbXmlGenerator;
import de.statspez.pleditor.generator.xml.RawMappingXmlGenerator;
import de.statspez.pleditor.generator.xml.ThemenbereichXmlGenerator;
import java.io.PrintStream;
import java.util.List;

public class PlausibilisierungXmlGenerator
extends AbstractXmlGenerator {
    private final String version = "3.5";

    public void generateXml(MetaCustomPlausibilisierung plausi, PrintStream out) throws Exception {
        MetaMapping rawMapping;
        MetaRawDataSet rawDsb;
        MetaMapping mapping;
        MetaDsbObjekt dsb;
        MetaThemenbereich tb;
        String abstand = "  ";
        out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        out.print(String.valueOf(abstand) + "<" + Tags.printTag("plausibility"));
        this.printAttribut(out, "version", "3.5");
        this.printAttribut(out, "refs", "id");
        out.print(" xmlns:edt=\"http://www.werum.de/pl-editor\" ");
        out.print(" xmlns:ssp=\"http://www.destatis.de/schema/datml-ssp/1.0\" ");
        this.printAttribut(out, "name", plausi.getName());
        this.printAttribut(out, "id", plausi.getId());
        if (plausi.getIdentifikation() != null && plausi.getIdentifikation().trim().length() > 0) {
            this.printAttribut(out, "survey-id", plausi.getIdentifikation());
        }
        if ((tb = plausi.rootThemenbereich()) != null) {
            this.printAttribut(out, "tb-name", tb.getName());
            this.printAttribut(out, "tb-id", tb.getId());
        }
        if ((dsb = plausi.getUsedDsbObjekt()) != null) {
            this.printAttribut(out, "dsb-name", dsb.getName());
            this.printAttribut(out, "dsb-id", dsb.getId());
        }
        if ((mapping = plausi.usedMappings()) != null) {
            this.printAttribut(out, "mapping-name", mapping.getName());
            this.printAttribut(out, "mapping-id", mapping.getId());
        }
        if ((rawDsb = plausi.getRawDataSet()) != null) {
            this.printAttribut(out, "raw-set-name", rawDsb.getName());
            if (rawDsb.getId() != null && rawDsb.getId().length() > 0) {
                this.printAttribut(out, "raw-set-id", rawDsb.getId());
            }
        }
        if ((rawMapping = plausi.getRawMapping()) != null) {
            this.printAttribut(out, "raw-mapping-name", rawMapping.getName());
            if (rawMapping.getId() != null && rawMapping.getId().length() > 0) {
                this.printAttribut(out, "raw-mapping-id", rawMapping.getId());
            }
        }
        out.println(">");
        MetaStatspezObjekt referredElement = (MetaStatspezObjekt)plausi.referredElement();
        String abstand1 = this.indentation(abstand, 1);
        if (plausi.isErhebung()) {
            MetaCustomPLMaterial erhebung = (MetaCustomPLMaterial)referredElement;
            this.printContext(out, abstand1, erhebung);
        } else {
            this.printLeeresContext(out, abstand1);
        }
        if (referredElement != null) {
            this.printProperties(out, referredElement, abstand1);
            this.printObjectContext(out, referredElement, abstand1);
        } else {
            this.printLeeresContext(out, abstand1);
        }
        this.printPlspezifikationen(plausi, out, abstand1);
        out.println(String.valueOf(abstand) + "</" + Tags.printTag("plausibility") + ">");
    }

    private void printPlspezifikationen(MetaCustomPlausibilisierung plausi, PrintStream out, String indentation) throws Exception {
        out.println(String.valueOf(indentation) + "<" + Tags.printTag("specifications") + ">");
        String abstand2 = this.indentation(indentation, 1);
        MerkmalXmlGenerator merkmalPrinter = new MerkmalXmlGenerator();
        List list = this.sort(plausi.getMerkmale());
        int i = 0;
        while (i < list.size()) {
            MetaMerkmal tmp = (MetaMerkmal)list.get(i);
            merkmalPrinter.printMerkmal(out, tmp, abstand2);
            ++i;
        }
        AuspraegungsgruppeXmlGenerator auspraegungsgruppePrinter = new AuspraegungsgruppeXmlGenerator();
        list = this.sort(plausi.getAuspraegungsgruppen());
        int i2 = 0;
        while (i2 < list.size()) {
            MetaAuspraegungsgruppe tmp = (MetaAuspraegungsgruppe)list.get(i2);
            auspraegungsgruppePrinter.printAuspraegungsgruppe(out, tmp, abstand2);
            ++i2;
        }
        FunktionXmlGenerator allgFunktionPrinter = new FunktionXmlGenerator();
        list = this.sort(plausi.getFunktionen());
        int i3 = 0;
        while (i3 < list.size()) {
            MetaCustomFunktion tmp = (MetaCustomFunktion)list.get(i3);
            allgFunktionPrinter.printFunktion(out, tmp, abstand2);
            ++i3;
        }
        ThemenbereichXmlGenerator themenbereichPrinter = new ThemenbereichXmlGenerator();
        list = this.sort(plausi.getThemenbereiche());
        int i4 = 0;
        while (i4 < list.size()) {
            MetaThemenbereich tmp = (MetaThemenbereich)list.get(i4);
            themenbereichPrinter.printThemenbereich(out, tmp, abstand2);
            ++i4;
        }
        DsbXmlGenerator dsbPrinter = new DsbXmlGenerator();
        list = this.sort(plausi.getDsbs());
        int i5 = 0;
        while (i5 < list.size()) {
            MetaDsbObjekt tmp = (MetaDsbObjekt)list.get(i5);
            dsbPrinter.printDsb(out, tmp, abstand2);
            ++i5;
        }
        RawDsbXmlGenerator rawDsbPrinter = new RawDsbXmlGenerator();
        list = this.sort(plausi.getRawDataSets());
        int i6 = 0;
        while (i6 < list.size()) {
            MetaRawDataSet tmp = (MetaRawDataSet)list.get(i6);
            rawDsbPrinter.print(out, abstand2, tmp);
            ++i6;
        }
        MappingXmlGenerator mappingPrinter = new MappingXmlGenerator();
        list = this.sort(plausi.getMappings());
        int i7 = 0;
        while (i7 < list.size()) {
            MetaCustomMapping tmp = (MetaCustomMapping)list.get(i7);
            if (!tmp.isVirtual()) {
                mappingPrinter.printMapping(out, tmp, abstand2);
            }
            ++i7;
        }
        RawMappingXmlGenerator rawMappingPrinter = new RawMappingXmlGenerator();
        int i8 = 0;
        while (i8 < list.size()) {
            MetaCustomMapping tmp = (MetaCustomMapping)list.get(i8);
            if (tmp.isVirtual()) {
                rawMappingPrinter.printMapping(out, tmp, abstand2);
            }
            ++i8;
        }
        PLMaterialXmlGenerator plMaterialPrinter = new PLMaterialXmlGenerator();
        list = this.sort(plausi.getPLMaterialien());
        int i9 = 0;
        while (i9 < list.size()) {
            MetaCustomPLMaterial tmp = (MetaCustomPLMaterial)list.get(i9);
            if (!tmp.istErhebung()) {
                plMaterialPrinter.printPLMaterial(out, tmp, abstand2);
            }
            ++i9;
        }
        ErhebungXmlGenerator erhebungPrinter = new ErhebungXmlGenerator();
        int i10 = 0;
        while (i10 < list.size()) {
            MetaCustomPLMaterial tmp = (MetaCustomPLMaterial)list.get(i10);
            if (tmp.istErhebung()) {
                erhebungPrinter.printErhebung(out, tmp, abstand2);
            }
            ++i10;
        }
        out.println(String.valueOf(indentation) + "</" + Tags.printTag("specifications") + ">");
    }
}

