/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.xml;

import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaMappingElement;
import de.statspez.pleditor.generator.parser.Tags;
import de.statspez.pleditor.generator.xml.AbstractXmlGenerator;
import de.statspez.pleditor.generator.xml.MetaToXmlConverter;
import java.io.PrintStream;
import java.util.Iterator;

public class MappingXmlGenerator
extends AbstractXmlGenerator {
    public void printMapping(PrintStream out, MetaMapping mapping, String indentation) throws Exception {
        if (mapping == null) {
            throw new Exception("Das Mapping muss angegeben werden.");
        }
        out.print(String.valueOf(indentation) + "<" + Tags.printTag("mapping"));
        this.printNameIdStateAttribute(out, mapping);
        this.printAttribut(out, "type", "normal");
        String tbName = "";
        String tbId = "";
        if (mapping.getThemenbereich() != null) {
            tbName = mapping.getThemenbereich().getName();
            tbId = mapping.getThemenbereich().getId();
        }
        this.printAttribut(out, "source", tbName);
        this.printAttribut(out, "source-id", tbId);
        String dsbName = "";
        String dsbId = "";
        if (mapping.getDSB() != null) {
            dsbName = mapping.getDSB().getName();
            dsbId = mapping.getDSB().getId();
        }
        this.printAttribut(out, "target", dsbName);
        this.printAttribut(out, "target-id", dsbId);
        out.println(">");
        String ab1 = this.indentation(indentation, 1);
        String ab2 = this.indentation(indentation, 2);
        String ab3 = this.indentation(indentation, 3);
        this.printProperties(out, mapping, ab1);
        this.printObjectContext(out, mapping, ab1);
        Iterator it = mapping.getMappingliste();
        while (it != null && it.hasNext()) {
            MetaMappingElement me = (MetaMappingElement)it.next();
            out.print(String.valueOf(ab1) + "<" + Tags.printTag("binding"));
            this.printAttribut(out, "id", me.getId());
            this.printAttribut(out, "type", MetaToXmlConverter.getMapingTyp(me.getMappingTyp()));
            out.println(">");
            String id = "";
            String name = "";
            if (me.getFeldTBListe() != null) {
                id = this.generateIds(me.getFeldTBListe());
                name = this.generateNamen(me.getFeldTBListe());
            }
            out.print(String.valueOf(ab2) + "<" + Tags.printTag("sourceField"));
            this.printAttribut(out, "id", id);
            out.print(">");
            out.print(name);
            out.println("</" + Tags.printTag("sourceField") + ">");
            id = "";
            name = "";
            if (me.getFeldDSB() != null) {
                id = me.getFeldDSB().getId();
                name = me.getFeldSatzart() != null ? String.valueOf(me.getFeldSatzart().getName()) + "#" + me.getFeldDSB().getName() : me.getFeldDSB().getName();
            }
            out.print(String.valueOf(ab2) + "<" + Tags.printTag("targetField"));
            this.printAttribut(out, "id", id);
            out.print(">");
            out.print(name);
            out.println("</" + Tags.printTag("targetField") + ">");
            id = "";
            name = "";
            if (me.getFeldSatzart() != null) {
                id = me.getFeldSatzart().getId();
                name = me.getFeldSatzart().getName();
            }
            out.print(String.valueOf(ab2) + "<" + Tags.printTag("recordField"));
            this.printAttribut(out, "id", id);
            out.print(">");
            out.print(name);
            out.println("</" + Tags.printTag("recordField") + ">");
            String code = me.getQuellRegel();
            if (code != null && code.trim().length() > 0) {
                out.println(String.valueOf(ab2) + "<" + Tags.printTag("sourceRule") + ">");
                if (code != null && code.trim().length() > 0) {
                    this.printCDATA(out, Tags.printTag("code"), code, ab3);
                }
                out.println(String.valueOf(ab2) + "</" + Tags.printTag("sourceRule") + ">");
            }
            if ((code = me.getZielRegel()) != null && code.trim().length() > 0) {
                out.println(String.valueOf(ab2) + "<" + Tags.printTag("targetRule") + ">");
                if (code != null && code.trim().length() > 0) {
                    this.printCDATA(out, Tags.printTag("code"), code, ab1);
                }
                out.println(String.valueOf(ab2) + "</" + Tags.printTag("targetRule") + ">");
            }
            out.println(String.valueOf(ab1) + "</" + Tags.printTag("binding") + ">");
        }
        out.println(String.valueOf(indentation) + "</" + Tags.printTag("mapping") + ">");
    }
}

