/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.codegen.mapping.MappingProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.mapping.MappingProgramGenerator;
import de.statspez.pleditor.generator.codegen.mapping.structure.MappingMeta;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.meta.MetaCustomMapping;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.runtime.mapping.MappingFactory;
import de.statspez.pleditor.generator.runtime.mapping.MappingInterface;
import de.statspez.pleditor.generator.runtime.mapping.SplittetSatzImpl;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.test.FieldValues;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCase;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCaseResult;
import de.statspez.pleditor.generator.runtime.test.PlausiTestResult;
import de.statspez.pleditor.generator.runtime.test.TestFailure;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MappingTestCase
extends PlausiTestCase {
    private int direction;
    private int errorLevel = 1;
    private List inputValues = new ArrayList();
    private List outputValues = new ArrayList();
    private boolean testDeprecatedMapping;

    public int getDirection() {
        return this.direction;
    }

    private int getInterpreterDirection() {
        int interpreterDirection = 0;
        switch (this.getDirection()) {
            case 3: {
                interpreterDirection = 102;
                break;
            }
            case 4: {
                interpreterDirection = 103;
                break;
            }
            case 1: {
                interpreterDirection = 100;
                break;
            }
            case 2: {
                interpreterDirection = 101;
                break;
            }
        }
        return interpreterDirection;
    }

    public void setDirection(String direction) {
        if (direction.equals("RAW_TO_TB")) {
            this.direction = 1;
        } else if (direction.equals("TB_TO_RAW")) {
            this.direction = 2;
        } else if (direction.equals("DSB_TO_TB")) {
            this.direction = 3;
        } else if (direction.equals("TB_TO_DSB")) {
            this.direction = 4;
        }
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(int errorLevel) {
        this.errorLevel = errorLevel;
    }

    public List getInputValues() {
        return this.inputValues;
    }

    public HashMap getInputValuesAsMap() {
        return this.convertListToMap(this.inputValues);
    }

    public void addInputValue(FieldValues value) {
        this.inputValues.add(value);
    }

    public List getOutputValues() {
        return this.outputValues;
    }

    public HashMap getOutputValuesAsMap() {
        return this.convertListToMap(this.outputValues);
    }

    public void addOutputValue(FieldValues value) {
        this.outputValues.add(value);
    }

    private HashMap convertListToMap(List list) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (FieldValues fieldValues : list) {
            Iterator fieldKeyIterator = fieldValues.getFields();
            while (fieldKeyIterator.hasNext()) {
                String fieldKey = (String)fieldKeyIterator.next();
                result.put(fieldKey, fieldValues.getValue(fieldKey));
            }
        }
        return result;
    }

    public boolean isTestDeprecatedMapping() {
        return this.testDeprecatedMapping;
    }

    public void setTestDeprecatedMapping(boolean testDeprecatedMapping) {
        this.testDeprecatedMapping = testDeprecatedMapping;
    }

    @Override
    public void execute(PlausiInterface plausi, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            try {
                MappingInterface mapping = new MappingFactory().createMapping(plausi.getPlausiName(), this.getDirection(), plausi.getClass().getClassLoader());
                if (mapping != null) {
                    SimpleDataset input = new SimpleDataset(this.getInputValuesAsMap());
                    input.setIndicesPrefix("[");
                    input.setIndicesSuffix("]");
                    HashMap outMapMappingProgramm = new HashMap();
                    SimpleDataset output = new SimpleDataset(outMapMappingProgramm);
                    output.setIndicesPrefix("[");
                    output.setIndicesSuffix("]");
                    mapping.map(input, output);
                    this.handleMapping(outMapMappingProgramm, testCaseResult, "Java");
                }
            }
            catch (Exception ex) {
                testCaseResult.addFailure(new TestFailure(this.getName(), "Java", 5, ex));
                result.addTestCaseResult(testCaseResult);
            }
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }

    @Override
    public void interprete(MetaCustomPlausibilisierung plausi, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            try {
                MetaCustomMapping mapping = null;
                Iterator mappingIterator = plausi.getMappings();
                while (mappingIterator.hasNext()) {
                    MetaCustomMapping currentMapping = (MetaCustomMapping)mappingIterator.next();
                    if (currentMapping.getThemenbereich() != plausi.rootThemenbereich()) continue;
                    if (this.getDirection() == 3 || this.getDirection() == 4) {
                        if (currentMapping.getDSB() == null) continue;
                        mapping = currentMapping;
                        break;
                    }
                    if (this.getDirection() != 1 && this.getDirection() != 2 || currentMapping.getRawDataSet() == null) continue;
                    mapping = currentMapping;
                    break;
                }
                HashMap inputValues = null;
                HashMap outputValues = new HashMap();
                if (mapping != null || this.isTestDeprecatedMapping()) {
                    inputValues = this.getInputValuesAsMap();
                }
                if (mapping != null) {
                    MappingMeta mappingMeta = new MappingMeta(this.getInterpreterDirection(), mapping);
                    String program = new MappingProgramGenerator().createMappingProgram(mappingMeta);
                    this.map(program, inputValues, outputValues);
                    this.handleMapping(outputValues, testCaseResult, "Interpreter");
                }
                if (this.isTestDeprecatedMapping()) {
                    String program = new MappingProgramCodeGenerator().createMappingProgram(plausi, this.getInterpreterDirection());
                    outputValues = new HashMap();
                    this.map(program, inputValues, outputValues);
                    this.handleMapping(outputValues, testCaseResult, "Interpreter");
                }
            }
            catch (Exception ex) {
                testCaseResult.addFailure(new TestFailure(this.getName(), "Interpreter", 5, ex));
                result.addTestCaseResult(testCaseResult);
            }
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }

    @Override
    public void performJavaScript(MetaCustomPlausibilisierung plausi, File javaScriptPlausiFile, PlausiTestResult result) {
    }

    private void map(String program, Map inputValues, Map outputValues) {
        InterpreterContext interpreterContext = this.buildInterpreterContext(inputValues, outputValues);
        ProgramInterpreter interpreter = new ProgramInterpreter();
        interpreter.execute(Helper.metaStructureFor(program), interpreterContext);
    }

    private InterpreterContext buildInterpreterContext(Map inputValues, Map outputValues) {
        InterpreterContext result = new InterpreterContext();
        result.setCheckArrayIndices(false);
        SimpleDataset inputDataset = new SimpleDataset(inputValues);
        inputDataset.setIndicesPrefix("[");
        inputDataset.setIndicesSuffix("]");
        SimpleDataset outputDataset = new SimpleDataset(outputValues);
        outputDataset.setIndicesPrefix("[");
        outputDataset.setIndicesSuffix("]");
        result.setSatz(new SplittetSatzImpl(inputDataset, outputDataset));
        return result;
    }

    private void handleMapping(Map outputMap, PlausiTestCaseResult testCaseResult, String context) {
        HashMap expectedOutputMap = this.getOutputValuesAsMap();
        for (String key : expectedOutputMap.keySet()) {
            String value = (String)outputMap.get(key);
            String expectedValue = (String)expectedOutputMap.get(key);
            if (value != null) {
                outputMap.remove(key);
                if (value.equals(expectedValue)) continue;
                testCaseResult.addFailure(new TestFailure(this.getName(), context, 7, key, 10, expectedValue, value));
                continue;
            }
            testCaseResult.addFailure(new TestFailure(this.getName(), context, 6, key));
        }
        Iterator outputIterator = outputMap.keySet().iterator();
        while (outputIterator.hasNext()) {
            testCaseResult.addFailure(new TestFailure(this.getName(), context, 5, (String)outputIterator.next()));
        }
    }
}

